/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.commons.rest.builder.request;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.mule.connectors.commons.rest.builder.request.Method;
import com.mule.connectors.commons.rest.builder.request.Request;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRequest
implements Request {
    private static final Logger logger = LoggerFactory.getLogger(SimpleRequest.class);
    private final Method method;
    private String path;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> queryParams = new HashMap<String, String>();
    private Map<String, String> pathParams = new HashMap<String, String>();
    private Object entity = new Form();
    private String contentType = "application/xml";
    private String accept = "application/xml";
    private static final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JaxbAnnotationModule());

    public SimpleRequest(Method method) {
        this.method = method;
    }

    @Override
    public Response execute(Client client) {
        WebTarget target = client.target("").path(this.getPath());
        target = target.resolveTemplates((Map)Maps.newHashMap(this.getPathParams()));
        for (Map.Entry<String, String> entry : this.getQueryParams().entrySet()) {
            target = target.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        logger.debug("Request method is {}", (Object)this.getMethod());
        logger.debug("Target path is: {}", (Object)target.getUri());
        Invocation.Builder requestBuilder = target.request().accept(new String[]{this.getAccept()});
        for (Map.Entry<String, String> entry : this.getHeaders().entrySet()) {
            requestBuilder.header(entry.getKey(), (Object)entry.getValue());
            logger.debug("Header: '{}': {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
        if ((this.getContentType().equals("application/x-www-form-urlencoded") || this.getContentType().equals("multipart/form-data")) && Optional.fromNullable((Object)this.getEntity()).isPresent()) {
            this.setEntity(new Form((MultivaluedMap)new MultivaluedHashMap((Map)objectMapper.convertValue(this.getEntity(), Map.class))));
        }
        Response response = this.getMethod().execute(requestBuilder, this.getEntity(), this.getContentType());
        logger.debug("Executed Request with Entity: {}", this.getEntity());
        response.bufferEntity();
        logger.debug("Response buffered.");
        return response;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getAccept() {
        return this.accept;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addQueryParam(String key, String value) {
        this.queryParams.put(key, value);
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public void addPathParam(String key, String value) {
        this.pathParams.put(key, value);
    }

    public void setPathParams(Map<String, String> pathParams) {
        this.pathParams = pathParams;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }
}

