/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.viewtobitmaplibrary;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.View;
import com.muddzdev.viewtobitmaplibrary.OnBitmapSaveListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ViewToBitmap {
    private static final String EXTENSION_PNG = ".png";
    private static final String EXTENSION_JPG = ".jpg";
    private static final String EXTENSION_NOMEDIA = ".nomedia";
    private static final String TAG = "ViewToBitmap";
    private static final int JPG_MAX_QUALITY = 100;
    private Context context;
    private View view;
    private int jpgQuality;
    private boolean saveAsPNG;
    private boolean saveAsNomedia;
    private String fileName;
    private String folderName;
    private OnBitmapSaveListener onBitmapSaveListener;

    public ViewToBitmap(@NonNull Context context) {
        this.context = context;
    }

    public ViewToBitmap(@NonNull Context context, @NonNull View view, String folderName) {
        this.context = context;
        this.view = view;
        this.folderName = folderName;
    }

    public ViewToBitmap setSaveAsNomedia(boolean saveAsNomedia) {
        this.saveAsNomedia = saveAsNomedia;
        return this;
    }

    public ViewToBitmap setSaveAsPNG(boolean saveAsPNG) {
        this.saveAsPNG = saveAsPNG;
        return this;
    }

    public ViewToBitmap setJpgQuality(int jpgQuality) {
        this.jpgQuality = jpgQuality;
        return this;
    }

    public ViewToBitmap setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public ViewToBitmap setFolderName(String folderName) {
        this.folderName = folderName;
        return this;
    }

    private String getFolderName() {
        String result = this.folderName == "" || this.folderName.isEmpty() ? String.valueOf(System.currentTimeMillis()) : this.folderName;
        return result;
    }

    public ViewToBitmap setView(View view) {
        this.view = view;
        return this;
    }

    public ViewToBitmap setOnBitmapSaveListener(OnBitmapSaveListener onBitmapSaveListener) {
        this.onBitmapSaveListener = onBitmapSaveListener;
        return this;
    }

    public ViewToBitmap saveToBitmap() {
        AsyncSaveBitmap asyncSaveBitmap = new AsyncSaveBitmap();
        asyncSaveBitmap.execute(new Void[0]);
        return this;
    }

    private void onBitmapSavedListener(boolean isSaved, String path) {
        if (this.onBitmapSaveListener != null) {
            this.onBitmapSaveListener.onBitmapSaved(isSaved, path);
        }
    }

    private String getFileName() {
        String result = this.fileName == null || this.fileName.isEmpty() ? String.valueOf(System.currentTimeMillis()) : this.fileName;
        return result;
    }

    private String getFileExtension() {
        String result = this.saveAsPNG ? EXTENSION_PNG : (this.saveAsNomedia ? EXTENSION_NOMEDIA : EXTENSION_JPG);
        return result;
    }

    private Bitmap viewToBitmap() {
        Bitmap bitmap = null;
        if (this.view != null) {
            this.view.setDrawingCacheEnabled(true);
            this.view.getDrawingCache();
            this.view.buildDrawingCache();
            bitmap = Bitmap.createBitmap((Bitmap)this.view.getDrawingCache());
            this.view.setDrawingCacheEnabled(false);
            this.view.buildDrawingCache(false);
        }
        return bitmap;
    }

    private class AsyncSaveBitmap
    extends AsyncTask<Void, Void, Void>
    implements MediaScannerConnection.OnScanCompletedListener {
        private AsyncSaveBitmap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected Void doInBackground(Void ... params) {
            File file;
            block8: {
                File myDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), ViewToBitmap.this.getFolderName());
                myDir.mkdirs();
                file = new File(myDir, ViewToBitmap.this.getFileName() + ViewToBitmap.this.getFileExtension());
                int quality = 0;
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    if (ViewToBitmap.this.saveAsPNG) {
                        ViewToBitmap.this.viewToBitmap().compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
                        break block8;
                    }
                    if (ViewToBitmap.this.jpgQuality == 0) {
                        quality = 100;
                    }
                    ViewToBitmap.this.viewToBitmap().compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ViewToBitmap.this.onBitmapSavedListener(false, null);
                    MediaScannerConnection.scanFile((Context)ViewToBitmap.this.context, (String[])new String[]{file.toString()}, null, (MediaScannerConnection.OnScanCompletedListener)this);
                }
                catch (NullPointerException e2) {
                    e2.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            MediaScannerConnection.scanFile((Context)ViewToBitmap.this.context, (String[])new String[]{file.toString()}, null, (MediaScannerConnection.OnScanCompletedListener)this);
                            throw throwable;
                        }
                    }
                    MediaScannerConnection.scanFile((Context)ViewToBitmap.this.context, (String[])new String[]{file.toString()}, null, (MediaScannerConnection.OnScanCompletedListener)this);
                }
            }
            MediaScannerConnection.scanFile((Context)ViewToBitmap.this.context, (String[])new String[]{file.toString()}, null, (MediaScannerConnection.OnScanCompletedListener)this);
            return null;
        }

        public void onScanCompleted(String path, Uri uri) {
            if (uri != null && path != null) {
                ViewToBitmap.this.onBitmapSavedListener(true, path);
                Log.i((String)ViewToBitmap.TAG, (String)("PATH: " + path));
                Log.i((String)ViewToBitmap.TAG, (String)("URI: " + uri));
            } else {
                ViewToBitmap.this.onBitmapSavedListener(false, null);
            }
        }
    }
}

