/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.styleabletoast;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.FontRes;
import android.support.annotation.NonNull;
import android.support.annotation.StyleRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v4.widget.TextViewCompat;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.muddzdev.styleabletoast.R;
import com.muddzdev.styleabletoast.Utils;

@SuppressLint(value={"ViewConstructor"})
public class StyleableToast
extends LinearLayout {
    private int cornerRadius;
    private int backgroundColor;
    private int strokeColor;
    private int strokeWidth;
    private int iconStart;
    private int iconEnd;
    private int textColor;
    private int font;
    private int length;
    private int style;
    private float textSize;
    private boolean isTextSizeFromStyleXml = false;
    private boolean solidBackground;
    private boolean textBold;
    private String text;
    private TypedArray typedArray;
    private TextView textView;
    private int gravity;
    private Toast toast;
    private LinearLayout rootLayout;

    public static StyleableToast makeText(@NonNull Context context, String text, int length, @StyleRes int style) {
        return new StyleableToast(context, text, length, style);
    }

    public static StyleableToast makeText(@NonNull Context context, String text, @StyleRes int style) {
        return new StyleableToast(context, text, 0, style);
    }

    private StyleableToast(@NonNull Context context, String text, int length, @StyleRes int style) {
        super(context);
        this.text = text;
        this.length = length;
        this.style = style;
    }

    private StyleableToast(Builder builder) {
        super(builder.context);
        this.backgroundColor = builder.backgroundColor;
        this.cornerRadius = builder.cornerRadius;
        this.iconEnd = builder.iconEnd;
        this.iconStart = builder.iconStart;
        this.strokeColor = builder.strokeColor;
        this.strokeWidth = builder.strokeWidth;
        this.solidBackground = builder.solidBackground;
        this.textColor = builder.textColor;
        this.textSize = builder.textSize;
        this.textBold = builder.textBold;
        this.font = builder.font;
        this.text = builder.text;
        this.gravity = builder.gravity;
        this.length = builder.length;
    }

    private void inflateToastLayout() {
        View v = StyleableToast.inflate((Context)this.getContext(), (int)R.layout.styleable_layout, null);
        this.rootLayout = (LinearLayout)v.getRootView();
        this.textView = (TextView)v.findViewById(R.id.textview);
        if (this.style > 0) {
            this.typedArray = this.getContext().obtainStyledAttributes(this.style, R.styleable.StyleableToast);
        }
        this.makeShape();
        this.makeTextView();
        this.makeIcon();
        if (this.typedArray != null) {
            this.typedArray.recycle();
        }
    }

    private void createAndShowToast() {
        this.toast = new Toast(this.getContext());
        this.toast.setGravity(this.gravity, 0, this.gravity == 17 ? 0 : this.toast.getYOffset());
        this.toast.setDuration(this.length == 1 ? 1 : 0);
        this.toast.setView((View)this.rootLayout);
        this.toast.show();
    }

    public void show() {
        this.inflateToastLayout();
        this.createAndShowToast();
    }

    public void cancel() {
        if (this.toast != null) {
            this.toast.cancel();
        }
    }

    private void makeShape() {
        this.loadShapeAttributes();
        GradientDrawable gradientDrawable = (GradientDrawable)this.rootLayout.getBackground().mutate();
        gradientDrawable.setAlpha(this.getResources().getInteger(R.integer.defaultBackgroundAlpha));
        if (this.strokeWidth > 0) {
            gradientDrawable.setStroke(this.strokeWidth, this.strokeColor);
        }
        if (this.cornerRadius > -1) {
            gradientDrawable.setCornerRadius((float)this.cornerRadius);
        }
        if (this.backgroundColor != 0) {
            gradientDrawable.setColor(this.backgroundColor);
        }
        if (this.solidBackground) {
            gradientDrawable.setAlpha(this.getResources().getInteger(R.integer.fullBackgroundAlpha));
        }
        this.rootLayout.setBackground((Drawable)gradientDrawable);
    }

    private void makeTextView() {
        this.loadTextViewAttributes();
        this.textView.setText((CharSequence)this.text);
        if (this.textColor != 0) {
            this.textView.setTextColor(this.textColor);
        }
        if (this.textSize > 0.0f) {
            this.textView.setTextSize(this.isTextSizeFromStyleXml ? 0 : 2, this.textSize);
        }
        if (this.font > 0) {
            this.textView.setTypeface(ResourcesCompat.getFont((Context)this.getContext(), (int)this.font), this.textBold ? 1 : 0);
        }
        if (this.textBold && this.font == 0) {
            this.textView.setTypeface(this.textView.getTypeface(), 1);
        }
    }

    private void makeIcon() {
        Drawable drawable;
        this.loadIconAttributes();
        int paddingVertical = (int)this.getResources().getDimension(R.dimen.toast_vertical_padding);
        int paddingHorizontal1 = (int)this.getResources().getDimension(R.dimen.toast_horizontal_padding_icon_side);
        int paddingNoIcon = (int)this.getResources().getDimension(R.dimen.toast_horizontal_padding_empty_side);
        int iconSize = (int)this.getResources().getDimension(R.dimen.icon_size);
        if (this.iconStart != 0 && (drawable = ContextCompat.getDrawable((Context)this.getContext(), (int)this.iconStart)) != null) {
            drawable.setBounds(0, 0, iconSize, iconSize);
            TextViewCompat.setCompoundDrawablesRelative((TextView)this.textView, (Drawable)drawable, null, null, null);
            if (Utils.isRTL()) {
                this.rootLayout.setPadding(paddingNoIcon, paddingVertical, paddingHorizontal1, paddingVertical);
            } else {
                this.rootLayout.setPadding(paddingHorizontal1, paddingVertical, paddingNoIcon, paddingVertical);
            }
        }
        if (this.iconEnd != 0 && (drawable = ContextCompat.getDrawable((Context)this.getContext(), (int)this.iconEnd)) != null) {
            drawable.setBounds(0, 0, iconSize, iconSize);
            TextViewCompat.setCompoundDrawablesRelative((TextView)this.textView, null, null, (Drawable)drawable, null);
            if (Utils.isRTL()) {
                this.rootLayout.setPadding(paddingHorizontal1, paddingVertical, paddingNoIcon, paddingVertical);
            } else {
                this.rootLayout.setPadding(paddingNoIcon, paddingVertical, paddingHorizontal1, paddingVertical);
            }
        }
        if (this.iconStart != 0 && this.iconEnd != 0) {
            Drawable drawableLeft = ContextCompat.getDrawable((Context)this.getContext(), (int)this.iconStart);
            Drawable drawableRight = ContextCompat.getDrawable((Context)this.getContext(), (int)this.iconEnd);
            if (drawableLeft != null && drawableRight != null) {
                drawableLeft.setBounds(0, 0, iconSize, iconSize);
                drawableRight.setBounds(0, 0, iconSize, iconSize);
                this.textView.setCompoundDrawables(drawableLeft, null, drawableRight, null);
                this.rootLayout.setPadding(paddingHorizontal1, paddingVertical, paddingHorizontal1, paddingVertical);
            }
        }
    }

    private void loadShapeAttributes() {
        if (this.style == 0) {
            return;
        }
        int defaultBackgroundColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.default_background_color);
        int defaultCornerRadius = (int)this.getResources().getDimension(R.dimen.default_corner_radius);
        this.solidBackground = this.typedArray.getBoolean(R.styleable.StyleableToast_solidBackground, false);
        this.backgroundColor = this.typedArray.getColor(R.styleable.StyleableToast_colorBackground, defaultBackgroundColor);
        this.cornerRadius = (int)this.typedArray.getDimension(R.styleable.StyleableToast_radius, (float)defaultCornerRadius);
        this.length = this.typedArray.getInt(R.styleable.StyleableToast_length, 0);
        this.gravity = this.typedArray.getInt(R.styleable.StyleableToast_gravity, 80);
        if (this.gravity == 1) {
            this.gravity = 17;
        } else if (this.gravity == 2) {
            this.gravity = 48;
        }
        if (this.typedArray.hasValue(R.styleable.StyleableToast_strokeColor) && this.typedArray.hasValue(R.styleable.StyleableToast_strokeWidth)) {
            this.strokeWidth = (int)this.typedArray.getDimension(R.styleable.StyleableToast_strokeWidth, 0.0f);
            this.strokeColor = this.typedArray.getColor(R.styleable.StyleableToast_strokeColor, 0);
        }
    }

    private void loadTextViewAttributes() {
        if (this.style == 0) {
            return;
        }
        this.textColor = this.typedArray.getColor(R.styleable.StyleableToast_textColor, this.textView.getCurrentTextColor());
        this.textBold = this.typedArray.getBoolean(R.styleable.StyleableToast_textBold, false);
        this.textSize = this.typedArray.getDimension(R.styleable.StyleableToast_textSize, 0.0f);
        this.font = this.typedArray.getResourceId(R.styleable.StyleableToast_font, 0);
        this.isTextSizeFromStyleXml = this.textSize > 0.0f;
    }

    private void loadIconAttributes() {
        if (this.style == 0) {
            return;
        }
        this.iconStart = this.typedArray.getResourceId(R.styleable.StyleableToast_iconStart, 0);
        this.iconEnd = this.typedArray.getResourceId(R.styleable.StyleableToast_iconEnd, 0);
    }

    public static class Builder {
        private int cornerRadius = -1;
        private int backgroundColor;
        private int strokeColor;
        private int strokeWidth;
        private int iconStart;
        private int iconEnd;
        private int textColor;
        private int font;
        private int length;
        private float textSize;
        private boolean solidBackground;
        private boolean textBold;
        private String text;
        private int gravity = 80;
        private StyleableToast toast;
        private final Context context;

        public Builder(@NonNull Context context) {
            this.context = context;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder textColor(@ColorInt int textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder textBold() {
            this.textBold = true;
            return this;
        }

        public Builder textSize(float textSize) {
            this.textSize = textSize;
            return this;
        }

        public Builder font(@FontRes int font) {
            this.font = font;
            return this;
        }

        public Builder backgroundColor(@ColorInt int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder solidBackground() {
            this.solidBackground = true;
            return this;
        }

        public Builder stroke(int strokeWidth, @ColorInt int strokeColor) {
            this.strokeWidth = Utils.toDp(this.context, strokeWidth);
            this.strokeColor = strokeColor;
            return this;
        }

        public Builder cornerRadius(int cornerRadius) {
            this.cornerRadius = Utils.toDp(this.context, cornerRadius);
            return this;
        }

        public Builder iconStart(@DrawableRes int iconStart) {
            this.iconStart = iconStart;
            return this;
        }

        public Builder iconEnd(@DrawableRes int iconEnd) {
            this.iconEnd = iconEnd;
            return this;
        }

        public Builder gravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public void show() {
            this.toast = new StyleableToast(this);
            this.toast.show();
        }
    }
}

