/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.styleabletoastlibrary;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.FontRes;
import android.support.annotation.NonNull;
import android.support.annotation.StyleRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.muddzdev.styleabletoastlibrary.OnToastFinishedListener;
import com.muddzdev.styleabletoastlibrary.R;
import com.muddzdev.styleabletoastlibrary.ToastLengthTracker;

@SuppressLint(value={"ViewConstructor"})
public class StyleableToast
extends RelativeLayout
implements OnToastFinishedListener {
    private int cornerRadius = -1;
    private int backgroundColor;
    private int strokeColor;
    private int strokeWidth;
    private int iconResLeft;
    private int iconResRight;
    private int textColor;
    private int fontId;
    private int length;
    private int style;
    private float textSize;
    private boolean isTextSizeFromStyle = false;
    private boolean hasAnimation;
    private boolean solidBackground;
    private boolean textBold;
    private String text;
    private TypedArray typedArray;
    private TextView textView;
    private Typeface typeface;
    private ImageView iconLeft;
    private ImageView iconRight;
    private Toast styleableToast;
    private LinearLayout rootLayout;
    private Context context;

    public static StyleableToast makeText(@NonNull Context context, String text, int length, @StyleRes int style) {
        return new StyleableToast(context, text, length, style);
    }

    public static StyleableToast makeText(@NonNull Context context, String text, @StyleRes int style) {
        return new StyleableToast(context, text, 0, style);
    }

    private StyleableToast(@NonNull Context context, String text, int length, @StyleRes int style) {
        super(context);
        this.context = context;
        this.text = text;
        this.length = length;
        this.style = style;
    }

    private StyleableToast(Builder builder) {
        super(builder.context);
        this.context = builder.context.getApplicationContext();
        this.backgroundColor = builder.backgroundColor;
        this.cornerRadius = builder.cornerRadius;
        this.iconResRight = builder.iconResRight;
        this.iconResLeft = builder.iconResLeft;
        this.strokeColor = builder.strokeColor;
        this.strokeWidth = builder.strokeWidth;
        this.hasAnimation = builder.hasAnimation;
        this.solidBackground = builder.solidBackground;
        this.textColor = builder.textColor;
        this.textSize = builder.textSize;
        this.textBold = builder.textBold;
        this.typeface = builder.typeface;
        this.fontId = builder.fontId;
        this.text = builder.text;
        this.length = builder.length;
    }

    private void initStyleableToast() {
        View v = StyleableToast.inflate((Context)this.getContext(), (int)R.layout.styleable_layout, null);
        this.rootLayout = (LinearLayout)v.findViewById(R.id.root);
        this.textView = (TextView)v.findViewById(R.id.textview);
        this.iconLeft = (ImageView)v.findViewById(R.id.icon_left);
        this.iconRight = (ImageView)v.findViewById(R.id.icon_right);
        if (this.style > 0) {
            this.typedArray = this.getContext().obtainStyledAttributes(this.style, R.styleable.StyleableToast);
        }
        this.makeShape();
        this.makeIcon();
        this.makeTextView();
        if (this.typedArray != null) {
            this.typedArray.recycle();
        }
        if (this.hasAnimation) {
            this.iconLeft.setAnimation(this.getAnimation());
            new ToastLengthTracker(this.length, this);
        }
    }

    public void show() {
        this.initStyleableToast();
        this.styleableToast = new Toast(this.context);
        this.styleableToast.setDuration(this.length == 1 ? 1 : 0);
        this.styleableToast.setView((View)this.rootLayout);
        this.styleableToast.show();
    }

    public void cancel() {
        if (this.styleableToast != null) {
            this.styleableToast.cancel();
        }
    }

    @Deprecated
    public Toast getStyleableToast() {
        return this.styleableToast;
    }

    private void makeShape() {
        this.loadShapeAttributes();
        GradientDrawable gradientDrawable = (GradientDrawable)this.rootLayout.getBackground();
        gradientDrawable.setCornerRadius(this.cornerRadius != -1 ? (float)this.cornerRadius : (float)R.dimen.default_corner_radius);
        gradientDrawable.setStroke(this.strokeWidth, this.strokeColor);
        if (this.backgroundColor == 0) {
            gradientDrawable.setColor(ContextCompat.getColor((Context)this.context, (int)R.color.defaultBackgroundColor));
        } else {
            gradientDrawable.setColor(this.backgroundColor);
        }
        if (this.solidBackground) {
            gradientDrawable.setAlpha(this.getResources().getInteger(R.integer.fullBackgroundAlpha));
        } else {
            gradientDrawable.setAlpha(this.getResources().getInteger(R.integer.defaultBackgroundAlpha));
        }
        this.rootLayout.setBackground((Drawable)gradientDrawable);
    }

    private void makeTextView() {
        this.loadTextViewStyleAttributes();
        this.textView.setText((CharSequence)this.text);
        if (this.textColor != 0) {
            this.textView.setTextColor(this.textColor);
        }
        if (this.textSize > 0.0f) {
            this.textView.setTextSize(this.isTextSizeFromStyle ? 0 : 2, this.textSize);
        }
        if (this.textBold && this.typeface == null) {
            this.textView.setTypeface(Typeface.create((String)this.context.getString(R.string.default_font), (int)1));
        } else if (this.textBold) {
            this.textView.setTypeface(Typeface.create((Typeface)this.typeface, (int)1));
        } else if (this.typeface != null) {
            this.textView.setTypeface(this.typeface);
        } else if (this.fontId > 0) {
            this.textView.setTypeface(ResourcesCompat.getFont((Context)this.context, (int)this.fontId));
        }
    }

    private void makeIcon() {
        this.loadIconAttributes();
        if (this.iconResLeft > 0 || this.iconResRight > 0) {
            int horizontalPadding = (int)this.getResources().getDimension(R.dimen.toast_horizontal_padding_with_icon);
            int verticalPadding = (int)this.getResources().getDimension(R.dimen.toast_vertical_padding);
            this.rootLayout.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        }
        if (this.iconResLeft > 0) {
            this.iconLeft.setBackgroundResource(this.iconResLeft);
            this.iconLeft.setVisibility(0);
        }
        if (this.iconResRight > 0) {
            this.iconRight.setBackgroundResource(this.iconResRight);
            this.iconRight.setVisibility(0);
        }
    }

    private void loadShapeAttributes() {
        if (this.style == 0) {
            return;
        }
        this.solidBackground = this.typedArray.getBoolean(R.styleable.StyleableToast_solidBackground, false);
        this.backgroundColor = this.typedArray.getColor(R.styleable.StyleableToast_colorBackground, ContextCompat.getColor((Context)this.context, (int)R.color.defaultBackgroundColor));
        this.cornerRadius = (int)this.typedArray.getDimension(R.styleable.StyleableToast_cornerRadius, (float)R.dimen.default_corner_radius);
        if (this.typedArray.hasValue(R.styleable.StyleableToast_length)) {
            this.length = this.typedArray.getInt(R.styleable.StyleableToast_length, 0);
        }
        if (Build.VERSION.SDK_INT >= 21 && this.typedArray.hasValue(R.styleable.StyleableToast_strokeColor) && this.typedArray.hasValue(R.styleable.StyleableToast_strokeWidth)) {
            this.strokeWidth = (int)this.typedArray.getDimension(R.styleable.StyleableToast_strokeWidth, 0.0f);
            this.strokeColor = this.typedArray.getColor(R.styleable.StyleableToast_strokeColor, 0);
        }
    }

    private void loadTextViewStyleAttributes() {
        if (this.style == 0) {
            return;
        }
        this.textColor = this.typedArray.getColor(R.styleable.StyleableToast_textColor, -1);
        this.textBold = this.typedArray.getBoolean(R.styleable.StyleableToast_textBold, false);
        this.textSize = this.typedArray.getDimension(R.styleable.StyleableToast_textSize, 0.0f);
        this.isTextSizeFromStyle = this.textSize > 0.0f;
        this.fontId = this.typedArray.getResourceId(R.styleable.StyleableToast_textFont, 0);
        String textFontPath = this.typedArray.getString(R.styleable.StyleableToast_textFont);
        if (textFontPath != null && textFontPath.contains("fonts/") && (textFontPath.contains(".otf") || textFontPath.contains(".ttf"))) {
            this.typeface = Typeface.createFromAsset((AssetManager)this.context.getAssets(), (String)textFontPath);
        }
    }

    private void loadIconAttributes() {
        if (this.style == 0) {
            return;
        }
        this.iconResLeft = this.typedArray.getResourceId(R.styleable.StyleableToast_iconLeft, 0);
        this.iconResRight = this.typedArray.getResourceId(R.styleable.StyleableToast_iconRight, 0);
    }

    public Animation getAnimation() {
        if (this.hasAnimation) {
            RotateAnimation anim = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
            anim.setInterpolator((Interpolator)new LinearInterpolator());
            anim.setRepeatCount(-1);
            anim.setDuration(1000L);
            return anim;
        }
        return null;
    }

    @Override
    public void onToastFinished() {
        if (this.getAnimation() != null) {
            this.getAnimation().cancel();
            this.getAnimation().reset();
        }
    }

    public static class Builder {
        private int cornerRadius = -1;
        private int backgroundColor;
        private int strokeColor;
        private int strokeWidth;
        private int iconResLeft;
        private int iconResRight;
        private int textColor;
        private int fontId;
        private int length;
        private float textSize;
        private boolean solidBackground;
        private boolean hasAnimation;
        private boolean textBold;
        private String text;
        private Typeface typeface;
        private final Context context;

        public Builder(@NonNull Context context) {
            this.context = context;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder textColor(@ColorInt int textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder textBold() {
            this.textBold = true;
            return this;
        }

        public Builder textSize(float textSize) {
            this.textSize = textSize;
            return this;
        }

        @Deprecated
        public Builder typeface(Typeface typeface) {
            this.typeface = typeface;
            return this;
        }

        public Builder font(@FontRes int font) {
            this.fontId = font;
            return this;
        }

        public Builder backgroundColor(@ColorInt int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder solidBackground() {
            this.solidBackground = true;
            return this;
        }

        public Builder stroke(int strokeWidth, @ColorInt int strokeColor) {
            this.strokeWidth = strokeWidth;
            this.strokeColor = strokeColor;
            return this;
        }

        public Builder cornerRadius(int cornerRadius) {
            this.cornerRadius = cornerRadius;
            return this;
        }

        public Builder iconResLeft(@DrawableRes int iconResLeft) {
            this.iconResLeft = iconResLeft;
            return this;
        }

        public Builder iconResRight(@DrawableRes int iconResRight) {
            this.iconResRight = iconResRight;
            return this;
        }

        @Deprecated
        public Builder spinIcon() {
            this.hasAnimation = true;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public void show() {
            StyleableToast styleableToast = new StyleableToast(this);
            styleableToast.show();
        }
    }
}

