/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.styleabletoastlibrary;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.StyleRes;
import android.support.v4.text.BidiFormatter;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.muddzdev.styleabletoastlibrary.DurationTracker;
import com.muddzdev.styleabletoastlibrary.OnToastFinished;
import com.muddzdev.styleabletoastlibrary.Utils;

public class StyleableToast
implements OnToastFinished {
    private static final String TAG = StyleableToast.class.getSimpleName();
    private static final String DEFAULT_CONDENSED_FONT = "sans-serif-condensed";
    private static final int DEFAULT_BACKGROUND = Color.parseColor((String)"#555555");
    private static final int DEFAULT_TEXT_COLOR = -1;
    private static final int DEFAULT_TEXT_SIZE = 16;
    private static final int DEFAULT_CORNER_RADIUS = 24;
    private static final int DEFAULT_HORIZONTAL_PADDING = 25;
    private static final float DEFAULT_VERTICAL_PADDING = 11.3f;
    private static final int DEFAULT_ALPHA = 230;
    private int cornerRadius = 24;
    private int backgroundColor = DEFAULT_BACKGROUND;
    private int alpha = 230;
    private int textColor = -1;
    private final Context context;
    private TextView textView;
    private Typeface typeface;
    private Toast styleableToast;
    private int style;
    private int icon;
    private int strokeColor;
    private int duration;
    private boolean textBold;
    private boolean hasAnimation;
    private float strokeWidth;
    private String text;
    private DurationTracker durationTracker;

    public static StyleableToast makeText(Context context, String text, int duration, int style) {
        return new StyleableToast(context, text, duration, style);
    }

    private StyleableToast(@NonNull Context context, String text, int duration, @StyleRes int style) {
        this.context = context;
        this.text = text;
        this.duration = duration;
        this.style = style;
    }

    private StyleableToast(Builder builder) {
        this.context = builder.context.getApplicationContext();
        this.text = builder.text;
        this.textColor = builder.textColor;
        this.textBold = builder.textBold;
        this.duration = builder.duration;
        this.backgroundColor = builder.backgroundColor;
        this.strokeColor = builder.strokeColor;
        this.strokeWidth = builder.strokeWidth;
        this.alpha = builder.alpha;
        this.cornerRadius = builder.cornerRadius;
        this.icon = builder.icon;
        this.hasAnimation = builder.hasAnimation;
        this.typeface = builder.typeface;
        this.durationTracker = new DurationTracker(this.duration, this);
    }

    public void setStyle(@StyleRes int style) {
        this.style = style;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColor = textColor;
    }

    public void setTextBold() {
        this.textBold = true;
    }

    public void setDuration(int duration) {
        if (duration == 1) {
            this.duration = duration;
        } else if (duration == 0) {
            this.duration = duration;
        } else {
            throw new IllegalStateException("StyleableB's duration must either be LENGTH_LONG or LENGTH_SHORT");
        }
    }

    public void setTypeface(Typeface typeface) {
        this.typeface = typeface;
    }

    public void spinIcon() {
        this.hasAnimation = true;
    }

    public void setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setStrokeColor(@ColorInt int strokeColor) {
        this.strokeColor = strokeColor;
    }

    public void setStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public void setCornerRadius(int cornerRadius) {
        this.cornerRadius = cornerRadius;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setIcon(@DrawableRes int icon) {
        this.icon = icon;
    }

    public void show() {
        this.styleableToast = new Toast(this.context);
        this.styleableToast.setDuration(this.duration);
        this.styleableToast.setView(this.getRootLayout());
        this.styleableToast.show();
        if (this.hasAnimation) {
            this.durationTracker.trackToastDuration();
        }
    }

    public void cancel() {
        this.styleableToast.cancel();
    }

    public Toast getStyleableToast() {
        return this.styleableToast;
    }

    private GradientDrawable getShape() {
        this.getShapeAttributes();
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setCornerRadius(Utils.getTypedValueInDP(this.context, this.cornerRadius));
        gradientDrawable.setStroke((int)Utils.getTypedValueInDP(this.context, this.strokeWidth), this.strokeColor);
        gradientDrawable.setColor(this.backgroundColor);
        gradientDrawable.setAlpha(this.alpha);
        return gradientDrawable;
    }

    private View getRootLayout() {
        this.getIconAttributes();
        int horizontalPadding = (int)Utils.getTypedValueInDP(this.context, 25.0f);
        int verticalPadding = (int)Utils.getTypedValueInDP(this.context, 11.3f);
        RelativeLayout rootLayout = new RelativeLayout(this.context);
        rootLayout.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        rootLayout.setBackground((Drawable)this.getShape());
        rootLayout.addView((View)this.getTextView());
        if (this.icon > 0) {
            rootLayout.addView((View)this.getIcon());
            rootLayout.setPadding(0, verticalPadding, 0, verticalPadding);
        }
        return rootLayout;
    }

    private TextView getTextView() {
        this.getTextViewAttributes();
        this.textView = new TextView(this.context);
        this.textView.setText((CharSequence)this.text);
        this.textView.setTextSize(2, 16.0f);
        this.textView.setTextColor(this.textColor);
        this.textView.setTypeface(this.getTypeface());
        this.textView.setMaxLines(4);
        if (this.icon > 0) {
            int leftPadding = (int)Utils.getTypedValueInDP(this.context, 41.0f);
            int rightPadding = (int)Utils.getTypedValueInDP(this.context, 25.0f);
            if (BidiFormatter.getInstance().isRtlContext()) {
                this.textView.setPadding(rightPadding, 0, leftPadding, 0);
            } else {
                this.textView.setPadding(leftPadding, 0, rightPadding, 0);
            }
        }
        return this.textView;
    }

    private ImageView getIcon() {
        if (this.icon > 0) {
            int marginLeft = (int)Utils.getTypedValueInDP(this.context, 15.0f);
            int marginRight = (int)Utils.getTypedValueInDP(this.context, 15.0f);
            int maxHeightVal = (int)Utils.getTypedValueInDP(this.context, 20.0f);
            int maxWidthVal = (int)Utils.getTypedValueInDP(this.context, 20.0f);
            ImageView imageView = new ImageView(this.context);
            imageView.setImageDrawable(this.context.getResources().getDrawable(this.icon));
            imageView.setAnimation(this.getAnimation());
            imageView.setMaxWidth(marginLeft + maxWidthVal);
            imageView.setMaxHeight(maxHeightVal);
            imageView.setAdjustViewBounds(true);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            if (BidiFormatter.getInstance().isRtlContext()) {
                layoutParams.setMargins(0, 0, marginRight, 0);
            } else {
                layoutParams.setMargins(marginLeft, 0, 0, 0);
            }
            layoutParams.addRule(15);
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            return imageView;
        }
        return null;
    }

    private void getShapeAttributes() {
        if (this.style > 0) {
            int[] colorAttrs = new int[]{0x1010031, 16843782};
            int[] floatAttrs = new int[]{16843551, 16843783};
            int[] dimenAttrs = new int[]{16843176};
            TypedArray colors = this.context.obtainStyledAttributes(this.style, colorAttrs);
            TypedArray floats = this.context.obtainStyledAttributes(this.style, floatAttrs);
            TypedArray dimens = this.context.obtainStyledAttributes(this.style, dimenAttrs);
            if (colors.hasValue(0)) {
                this.backgroundColor = colors.getColor(0, DEFAULT_BACKGROUND);
            }
            if (dimens.hasValue(0)) {
                this.cornerRadius = (int)dimens.getDimension(0, 24.0f);
            }
            if (floats.hasValue(0)) {
                this.alpha = (int)floats.getFloat(0, 230.0f);
            }
            if (Build.VERSION.SDK_INT >= 21) {
                this.strokeWidth = floats.getFloat(1, 0.0f);
                this.strokeColor = colors.getColor(1, 0);
            }
            colors.recycle();
            floats.recycle();
            dimens.recycle();
        }
    }

    private void getTextViewAttributes() {
        if (this.style > 0) {
            String fontStyle;
            int[] colorAttrs = new int[]{16842904};
            int[] stringAttrs = new int[]{16843692};
            int[] intsAttrs = new int[]{16842903};
            TypedArray colors = this.context.obtainStyledAttributes(this.style, colorAttrs);
            TypedArray strings = this.context.obtainStyledAttributes(this.style, stringAttrs);
            TypedArray ints = this.context.obtainStyledAttributes(this.style, intsAttrs);
            if (colors.hasValue(0)) {
                this.textColor = colors.getColor(0, -1);
            }
            if (strings.hasValue(0) && (fontStyle = strings.getString(0)) != null && !fontStyle.isEmpty()) {
                this.typeface = fontStyle.contains("fonts") ? Typeface.createFromAsset((AssetManager)this.context.getAssets(), (String)fontStyle) : Typeface.create((String)fontStyle, (int)0);
            }
            if (ints.hasValue(0)) {
                this.textBold = ints.getInt(0, 0) == 1;
            }
            colors.recycle();
            strings.recycle();
            ints.recycle();
        }
    }

    private void getIconAttributes() {
        if (this.style > 0) {
            int[] drawableAttrSet = new int[]{0x1010002};
            TypedArray drawables = this.context.obtainStyledAttributes(this.style, drawableAttrSet);
            if (drawables.hasValue(0)) {
                this.icon = drawables.getResourceId(0, 0);
            }
            drawables.recycle();
        }
    }

    private Animation getAnimation() {
        if (this.hasAnimation) {
            RotateAnimation anim = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
            anim.setInterpolator((Interpolator)new LinearInterpolator());
            anim.setRepeatCount(-1);
            anim.setDuration(1000L);
            return anim;
        }
        return null;
    }

    private Typeface getTypeface() {
        if (this.textBold && this.typeface == null) {
            return Typeface.create((String)DEFAULT_CONDENSED_FONT, (int)1);
        }
        if (this.textBold) {
            return Typeface.create((Typeface)this.typeface, (int)1);
        }
        if (this.typeface != null) {
            return Typeface.create((Typeface)this.typeface, (int)0);
        }
        return Typeface.create((String)DEFAULT_CONDENSED_FONT, (int)0);
    }

    @Override
    public void onToastFinished() {
        if (this.getAnimation() != null) {
            this.getAnimation().cancel();
            this.getAnimation().reset();
        }
    }

    static /* synthetic */ int access$1300() {
        return DEFAULT_BACKGROUND;
    }

    public static class Builder {
        private final Context context;
        private int backgroundColor = StyleableToast.access$1300();
        private int textColor = -1;
        private int alpha = 230;
        private int duration = 0;
        private int cornerRadius = 24;
        private int strokeWidth;
        private int icon;
        private int strokeColor;
        private boolean hasAnimation;
        private boolean textBold;
        private Typeface typeface;
        private String text;

        public Builder(@NonNull Context context) {
            this.context = context;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder textColor(@ColorInt int textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder textBold() {
            this.textBold = true;
            return this;
        }

        public Builder duration(int duration) {
            if (duration == 1) {
                this.duration = duration;
            } else if (duration == 0) {
                this.duration = duration;
            } else {
                throw new IllegalStateException("StyleableB's duration must either be LENGTH_LONG or LENGTH_SHORT");
            }
            return this;
        }

        public Builder typeface(Typeface typeface) {
            this.typeface = typeface;
            return this;
        }

        public Builder spinIcon() {
            this.hasAnimation = true;
            return this;
        }

        public Builder backgroundColor(@ColorInt int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder strokeColor(@ColorInt int strokeColor) {
            this.strokeColor = strokeColor;
            return this;
        }

        public Builder strokeWidth(int strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        public Builder cornerRadius(int cornerRadius) {
            this.cornerRadius = cornerRadius;
            return this;
        }

        public Builder alpha(int alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder icon(@DrawableRes int icon) {
            this.icon = icon;
            return this;
        }

        public StyleableToast build() {
            return new StyleableToast(this);
        }
    }
}

