/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.styleabletoastlibrary;

import android.os.CountDownTimer;
import com.muddzdev.styleabletoastlibrary.OnToastFinished;

public class ToastDurationWatcher {
    private static final int LENGTH_LONG = 3500;
    private static final int LENGTH_SHORT = 2000;
    private int duration;
    private OnToastFinished onToastFinished;

    public ToastDurationWatcher() {
        this.trackToastDuration();
    }

    public ToastDurationWatcher(int duration, OnToastFinished onToastFinished) {
        this.duration = duration;
        this.onToastFinished = onToastFinished;
        this.trackToastDuration();
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setOnToastFinished(OnToastFinished onToastFinished) {
        this.onToastFinished = onToastFinished;
    }

    private void trackToastDuration() {
        CountDownTimer countDownTimer = new CountDownTimer(this.getToastDuration() + 500L, 1000L){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                if (ToastDurationWatcher.this.onToastFinished != null) {
                    ToastDurationWatcher.this.onToastFinished.onToastFinished();
                }
            }
        };
        countDownTimer.start();
    }

    private long getToastDuration() {
        if (this.duration == 1) {
            return 3500L;
        }
        return 2000L;
    }
}

