/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.styleabletoastlibrary;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.AttrRes;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class Utils {
    public static float getTypedValueInDP(Context context, float value) {
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float getTypedValueInSP(Context context, float value) {
        return TypedValue.applyDimension((int)2, (float)value, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static TypedArray getStyleValuesColor(Context context, @AttrRes int attrId, int style) {
        TypedArray a = null;
        if (style > 0) {
            int[] AttrSet = new int[]{attrId};
            a = context.obtainStyledAttributes(style, AttrSet);
            int n = a.getColor(0, -3355444);
        }
        return a;
    }

    public static int getStyleValuesInt(Context context, @AttrRes int attrId, int style) {
        TypedArray a = null;
        if (style > 0) {
            int[] AttrSet = new int[]{attrId};
            a = context.obtainStyledAttributes(style, AttrSet);
            a.recycle();
        }
        return a.getInt(0, 0);
    }

    public static String getStyleValuesString(Context context, @AttrRes int attrId, int style) {
        TypedArray a = null;
        if (style > 0) {
            int[] AttrSet = new int[]{attrId};
            a = context.obtainStyledAttributes(style, AttrSet);
            a.recycle();
        }
        return a.getString(0);
    }

    public static boolean getStyleValuesBoolean(Context context, @AttrRes int attrId, int style) {
        TypedArray a = null;
        if (style > 0) {
            int[] AttrSet = new int[]{attrId};
            a = context.obtainStyledAttributes(style, AttrSet);
            a.recycle();
        }
        return a.getBoolean(0, false);
    }
}

