/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.styleabletoastlibrary;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.StyleRes;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.muddzdev.styleabletoastlibrary.OnToastFinished;
import com.muddzdev.styleabletoastlibrary.ToastDurationWatcher;
import com.muddzdev.styleabletoastlibrary.Utils;

public class StyleableToast
implements OnToastFinished {
    private static final String TAG = "StyleableToast";
    private static final String DEFAULT_CONDENSED_FONT = "sans-serif-condensed";
    private static final int DEFAULT_BACKGROUND = Color.parseColor((String)"#555555");
    private static final int DEFAULT_TEXT_COLOR = -1;
    private static final int DEFAULT_TEXT_SIZE = 16;
    private static final int DEFAULT_CORNER_RADIUS = 25;
    private static final int DEFAULT_HORIZONTAL_PADDING = 25;
    private static final int DEFAULT_VERTICAL_PADDING = 11;
    private static final int DEFAULT_ALPHA = 230;
    private static int MAX_ALPHA = 255;
    private final Context context;
    private TextView textView;
    private Typeface font;
    private float strokeWidth;
    private int duration;
    private int style;
    private int alpha;
    private int drawable;
    private int backgroundColor;
    private int textColor;
    private int strokeColor;
    private int cornerRadius = -1;
    private boolean isBold;
    private boolean isAnimation;
    private String toastMsg;

    public StyleableToast(Context context) {
        this.context = context.getApplicationContext();
    }

    public StyleableToast(Context context, String toastMsg, int duration) {
        this.context = context.getApplicationContext();
        this.toastMsg = toastMsg;
        this.duration = duration;
    }

    public StyleableToast(Context context, String toastMsg, int duration, @StyleRes int styleId) {
        this.context = context.getApplicationContext();
        this.toastMsg = toastMsg;
        this.duration = duration;
        this.style = styleId;
    }

    public void setStyle(@StyleRes int style) {
        this.style = style;
    }

    public void setToastMsg(String toastMsg) {
        this.toastMsg = toastMsg;
    }

    public void setBoldText() {
        this.isBold = true;
    }

    public void setTextFont(Typeface typeface) {
        this.font = typeface;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColor = textColor;
    }

    public void setTextStyle(boolean isBold, Typeface font) {
        this.textColor = this.textColor;
        this.font = font;
    }

    public void setTextStyle(@ColorInt int textColor, Typeface font) {
        this.textColor = textColor;
        this.font = font;
    }

    public void setTextStyle(@ColorInt int textColor, boolean isBold) {
        this.textColor = textColor;
        this.isBold = isBold;
    }

    public void setTextStyle(@ColorInt int textColor, boolean isBold, Typeface font) {
        this.textColor = textColor;
        this.isBold = isBold;
        this.font = font;
    }

    public StyleableToast spinIcon() {
        this.isAnimation = true;
        return this;
    }

    public void setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setToastStroke(int strokeWidth, @ColorInt int strokeColor) {
        this.strokeWidth = strokeWidth;
        this.strokeColor = strokeColor;
    }

    public void setCornerRadius(int cornerRadius) {
        this.cornerRadius = cornerRadius;
    }

    public void setMaxAlpha() {
        this.alpha = MAX_ALPHA;
    }

    public void setIcon(@DrawableRes int drawable) {
        this.drawable = drawable;
    }

    private Toast buildToast() {
        Toast toast = new Toast(this.context);
        toast.setDuration(this.duration);
        toast.setView(this.getToastLayout());
        return toast;
    }

    private View getToastLayout() {
        this.getImageViewStyleAttr();
        int horizontalPadding = (int)Utils.getTypedValueInDP(this.context, 25.0f);
        int verticalPadding = (int)Utils.getTypedValueInDP(this.context, 11.0f);
        RelativeLayout toastLayout = new RelativeLayout(this.context);
        toastLayout.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        toastLayout.setBackground((Drawable)this.getToastShape());
        toastLayout.addView((View)this.getTextView());
        if (this.drawable > 0) {
            toastLayout.addView((View)this.getIcon());
            toastLayout.setPadding(0, verticalPadding, 0, verticalPadding);
        }
        return toastLayout;
    }

    private void getToastShapeAttrs() {
        if (this.style > 0) {
            int[] colorAttrs = new int[]{0x1010031, 16843782};
            int[] floatAttrs = new int[]{16843551, 16843783};
            int[] dimenAttrs = new int[]{16843176};
            TypedArray colors = this.context.obtainStyledAttributes(this.style, colorAttrs);
            TypedArray floats = this.context.obtainStyledAttributes(this.style, floatAttrs);
            TypedArray dimens = this.context.obtainStyledAttributes(this.style, dimenAttrs);
            this.backgroundColor = colors.getColor(0, DEFAULT_BACKGROUND);
            this.cornerRadius = (int)dimens.getDimension(0, 25.0f);
            this.alpha = (int)floats.getFloat(0, 230.0f);
            if (Build.VERSION.SDK_INT >= 21) {
                this.strokeWidth = floats.getFloat(1, 0.0f);
                this.strokeColor = colors.getColor(1, 0);
            }
            colors.recycle();
            floats.recycle();
            dimens.recycle();
        }
    }

    private GradientDrawable getToastShape() {
        this.getToastShapeAttrs();
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setCornerRadius(this.getShapeCornerRadius());
        gradientDrawable.setStroke((int)this.getStrokeWidth(), this.getStrokeColor());
        gradientDrawable.setColor(this.getBackgroundColor());
        gradientDrawable.setAlpha(this.getShapeAlpha());
        return gradientDrawable;
    }

    private void getTextStylesAttr() {
        if (this.style > 0) {
            int[] colorAttrs = new int[]{16842904};
            int[] stringAttrs = new int[]{16843692};
            int[] intsAttrs = new int[]{16842903};
            TypedArray colors = this.context.obtainStyledAttributes(this.style, colorAttrs);
            TypedArray strings = this.context.obtainStyledAttributes(this.style, stringAttrs);
            TypedArray ints = this.context.obtainStyledAttributes(this.style, intsAttrs);
            this.textColor = colors.getColor(0, -1);
            String passedFont = strings.getString(0);
            if (passedFont != null && !passedFont.isEmpty()) {
                this.font = passedFont.contains("fonts") ? Typeface.createFromAsset((AssetManager)this.context.getAssets(), (String)passedFont) : Typeface.create((String)passedFont, (int)0);
            }
            this.isBold = ints.getInt(0, 0) == 1;
            colors.recycle();
            strings.recycle();
            ints.recycle();
        }
    }

    private TextView getTextView() {
        this.getTextStylesAttr();
        this.textView = new TextView(this.context);
        this.textView.setText((CharSequence)this.toastMsg);
        this.textView.setTextSize(2, 16.0f);
        this.textView.setTextColor(this.getTextColor());
        this.textView.setTypeface(this.getTypeface());
        this.textView.setMaxLines(2);
        if (this.drawable > 0) {
            int leftPadding = (int)Utils.getTypedValueInDP(this.context, 41.0f);
            int rightPadding = (int)Utils.getTypedValueInDP(this.context, 22.0f);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            this.textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.textView.setPadding(leftPadding, 0, rightPadding, 0);
        }
        return this.textView;
    }

    private Animation getAnimation() {
        if (this.isAnimation) {
            RotateAnimation anim = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
            anim.setInterpolator((Interpolator)new LinearInterpolator());
            anim.setRepeatCount(-1);
            anim.setDuration(1000L);
            return anim;
        }
        return null;
    }

    private void getImageViewStyleAttr() {
        if (this.style > 0) {
            int[] drawableAttrSet = new int[]{0x1010002};
            TypedArray drawableId = this.context.obtainStyledAttributes(this.style, drawableAttrSet);
            this.drawable = drawableId.getResourceId(0, 0);
            drawableId.recycle();
        }
    }

    private ImageView getIcon() {
        if (this.drawable > 0) {
            int marginLeft = (int)Utils.getTypedValueInDP(this.context, 15.0f);
            int maxHeightVal = (int)Utils.getTypedValueInDP(this.context, 20.0f);
            int maxWidthVal = (int)Utils.getTypedValueInDP(this.context, 20.0f);
            ImageView imageView = new ImageView(this.context);
            imageView.setImageDrawable(this.context.getResources().getDrawable(this.drawable));
            imageView.setAnimation(this.getAnimation());
            imageView.setMaxWidth(marginLeft + maxWidthVal);
            imageView.setMaxHeight(maxHeightVal);
            imageView.setAdjustViewBounds(true);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.setMargins(marginLeft, 0, 0, 0);
            layoutParams.addRule(15);
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            return imageView;
        }
        return null;
    }

    private float getStrokeWidth() {
        return Utils.getTypedValueInDP(this.context, this.strokeWidth);
    }

    private int getStrokeColor() {
        return this.strokeColor;
    }

    private float getShapeCornerRadius() {
        if (this.cornerRadius >= 0) {
            return Utils.getTypedValueInDP(this.context, this.cornerRadius);
        }
        return Utils.getTypedValueInDP(this.context, 25.0f);
    }

    private int getBackgroundColor() {
        if (this.backgroundColor == 0) {
            return DEFAULT_BACKGROUND;
        }
        return this.backgroundColor;
    }

    private int getShapeAlpha() {
        if (this.alpha == 0) {
            return 230;
        }
        return this.alpha;
    }

    private Typeface getTypeface() {
        if (this.isBold && this.font == null) {
            return Typeface.create((String)DEFAULT_CONDENSED_FONT, (int)1);
        }
        if (this.isBold && this.font != null) {
            return Typeface.create((Typeface)this.font, (int)1);
        }
        if (this.font != null) {
            return Typeface.create((Typeface)this.font, (int)0);
        }
        return Typeface.create((String)DEFAULT_CONDENSED_FONT, (int)0);
    }

    @ColorInt
    private int getTextColor() {
        if (this.textColor == 0 && this.style <= 0) {
            return -1;
        }
        return this.textColor;
    }

    public void show() {
        this.buildToast().show();
        if (this.isAnimation) {
            ToastDurationWatcher toastDurationWatcher = new ToastDurationWatcher(this.buildToast().getDuration(), this);
        }
    }

    @Override
    public void onToastFinished() {
        this.getAnimation().cancel();
        this.getAnimation().reset();
    }

    public static StyleableToast makeText(Context context, CharSequence text, int duration, int style) {
        StyleableToast styleableToast = new StyleableToast(context, text.toString(), duration, style);
        return styleableToast;
    }
}

