/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.quickshot;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.muddzdev.quickshot.PixelCopyHelper;
import com.muddzdev.quickshot.QuickShotUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;

public class QuickShot {
    private static final String EXTENSION_JPG = ".jpg";
    private static final String EXTENSION_PNG = ".png";
    private static final String EXTENSION_NOMEDIA = ".nomedia";
    private static final int JPG_MAX_QUALITY = 100;
    private boolean printStackTrace;
    private int jpgQuality = 100;
    private String fileExtension = ".jpg";
    private String filename = String.valueOf(System.currentTimeMillis());
    private String path;
    private Bitmap bitmap;
    private View view;
    private Context context;
    private QuickShotListener listener;

    private QuickShot(@NonNull View view) {
        this.view = view;
        this.context = view.getContext();
    }

    private QuickShot(@NonNull Bitmap bitmap, @NonNull Context context) {
        this.bitmap = bitmap;
        this.context = context;
    }

    public static QuickShot of(@NonNull View view) {
        return new QuickShot(view);
    }

    public static QuickShot of(@NonNull Bitmap bitmap, @NonNull Context context) {
        return new QuickShot(bitmap, context);
    }

    public QuickShot setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public QuickShot setPath(String path) {
        this.path = path;
        return this;
    }

    private void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public QuickShot toJPG() {
        this.jpgQuality = 100;
        this.setFileExtension(EXTENSION_JPG);
        return this;
    }

    public QuickShot toJPG(int jpgQuality) {
        this.jpgQuality = jpgQuality;
        this.setFileExtension(EXTENSION_JPG);
        return this;
    }

    public QuickShot toPNG() {
        this.setFileExtension(EXTENSION_PNG);
        return this;
    }

    public QuickShot toNomedia() {
        this.setFileExtension(EXTENSION_NOMEDIA);
        return this;
    }

    public QuickShot enableLogging() {
        this.printStackTrace = true;
        return this;
    }

    public QuickShot setResultListener(@NonNull QuickShotListener listener) {
        this.listener = listener;
        if (listener == null) {
            throw new NullPointerException("QuickShot.setResultListener() was provided with a null object reference");
        }
        return this;
    }

    private Context getContext() {
        if (this.context == null) {
            throw new NullPointerException("Attempt to save the picture failed: View or Context was null");
        }
        return this.context;
    }

    private Bitmap getBitmap() {
        if (this.bitmap != null) {
            return this.bitmap;
        }
        if (this.view instanceof TextureView) {
            this.bitmap = ((TextureView)this.view).getBitmap();
            Canvas canvas = new Canvas(this.bitmap);
            this.view.draw(canvas);
            canvas.setBitmap(null);
            return this.bitmap;
        }
        this.bitmap = Bitmap.createBitmap((int)this.view.getWidth(), (int)this.view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.bitmap);
        this.view.draw(canvas);
        canvas.setBitmap(null);
        return this.bitmap;
    }

    public void save() throws NullPointerException {
        if (this.view instanceof SurfaceView) {
            PixelCopyHelper.getSurfaceBitmap((SurfaceView)this.view, new PixelCopyHelper.PixelCopyListener(){

                @Override
                public void onSurfaceBitmapReady(Bitmap surfaceBitmap) {
                    new BitmapSaver(QuickShot.this.getContext(), surfaceBitmap, QuickShot.this.printStackTrace, QuickShot.this.path, QuickShot.this.filename, QuickShot.this.fileExtension, QuickShot.this.jpgQuality, QuickShot.this.listener).execute(new Void[0]);
                }

                @Override
                public void onSurfaceBitmapError(String errorMsg) {
                    QuickShot.this.listener.onQuickShotFailed(QuickShot.this.path, errorMsg);
                }
            });
        } else {
            new BitmapSaver(this.getContext(), this.getBitmap(), this.printStackTrace, this.path, this.filename, this.fileExtension, this.jpgQuality, this.listener).execute(new Void[0]);
        }
    }

    static class BitmapSaver
    extends AsyncTask<Void, Void, Void> {
        private final WeakReference<Context> weakContext;
        private Handler mainThreadHandler = new Handler(Looper.getMainLooper());
        private boolean printStacktrace;
        private int jpgQuality;
        private String errorMsg;
        private String path;
        private String filename;
        private String fileExtension;
        private Bitmap bitmap;
        private File file;
        private QuickShotListener listener;

        BitmapSaver(Context context, Bitmap bitmap, boolean printStacktrace, String path, String filename, String fileExtension, int jpgQuality, QuickShotListener listener) {
            this.weakContext = new WeakReference<Context>(context);
            this.bitmap = bitmap;
            this.printStacktrace = printStacktrace;
            this.path = path;
            this.filename = filename;
            this.fileExtension = fileExtension;
            this.jpgQuality = jpgQuality;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void saveLegacy() {
            if (this.path == null) {
                this.path = Environment.getExternalStorageDirectory() + File.separator + Environment.DIRECTORY_PICTURES;
            }
            File directory = new File(this.path);
            directory.mkdirs();
            this.file = new File(directory, this.filename + this.fileExtension);
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));){
                switch (this.fileExtension) {
                    case ".jpg": {
                        this.bitmap.compress(Bitmap.CompressFormat.JPEG, this.jpgQuality, (OutputStream)out);
                        return;
                    }
                    case ".png": {
                        this.bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)out);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                if (this.printStacktrace) {
                    e.printStackTrace();
                }
                this.errorMsg = e.toString();
                this.cancel(true);
                return;
            }
            finally {
                this.bitmap = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresApi(value=29)
        private void saveScopedStorage() {
            this.path = this.path != null ? Environment.DIRECTORY_PICTURES + File.separator + this.path : Environment.DIRECTORY_PICTURES;
            ContentValues contentValues = new ContentValues();
            contentValues.put("_display_name", this.filename);
            contentValues.put("relative_path", this.path);
            contentValues.put("mime_type", QuickShotUtils.getMimeType(this.fileExtension));
            ContentResolver resolver = ((Context)this.weakContext.get()).getContentResolver();
            Uri imageUri = resolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
            if (imageUri == null) {
                this.errorMsg = String.format("Couldn't insert ContentValues with data: [%s] into the ContentResolver", contentValues.toString());
                this.cancel(true);
                return;
            }
            try (OutputStream out = resolver.openOutputStream(imageUri);){
                switch (this.fileExtension) {
                    case ".jpg": {
                        this.bitmap.compress(Bitmap.CompressFormat.JPEG, this.jpgQuality, out);
                        break;
                    }
                    case ".png": {
                        this.bitmap.compress(Bitmap.CompressFormat.PNG, 0, out);
                    }
                }
                this.file = new File(this.path, this.filename + this.fileExtension);
            }
            catch (Exception e) {
                if (this.printStacktrace) {
                    e.printStackTrace();
                }
                this.errorMsg = e.toString();
                resolver.delete(imageUri, null, null);
                this.cancel(true);
            }
            finally {
                this.bitmap = null;
            }
        }

        protected Void doInBackground(Void ... voids) {
            if (QuickShotUtils.isAboveAPI29()) {
                this.saveScopedStorage();
            } else {
                this.saveLegacy();
            }
            return null;
        }

        protected void onPostExecute(Void v) {
            this.listener.onQuickShotSuccess(this.file.getAbsolutePath());
            if (!QuickShotUtils.isAboveAPI29()) {
                MediaScannerConnection.scanFile((Context)((Context)this.weakContext.get()), (String[])new String[]{this.file.getAbsolutePath()}, null, null);
            }
        }

        protected void onCancelled() {
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    BitmapSaver.this.listener.onQuickShotFailed(BitmapSaver.this.file.getAbsolutePath(), BitmapSaver.this.errorMsg);
                }
            });
        }
    }

    public static interface QuickShotListener {
        public void onQuickShotSuccess(String var1);

        public void onQuickShotFailed(String var1, String var2);
    }
}

