/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.quickshot;

import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.PixelCopy;
import android.view.SurfaceView;
import androidx.annotation.NonNull;

class PixelCopyHelper {
    PixelCopyHelper() {
    }

    static void getSurfaceBitmap(@NonNull SurfaceView surfaceView, final @NonNull PixelCopyListener listener) {
        final Bitmap bitmap = Bitmap.createBitmap((int)surfaceView.getWidth(), (int)surfaceView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        final HandlerThread handlerThread = new HandlerThread(PixelCopyHelper.class.getSimpleName());
        handlerThread.start();
        if (Build.VERSION.SDK_INT >= 24) {
            PixelCopy.request((SurfaceView)surfaceView, (Bitmap)bitmap, (PixelCopy.OnPixelCopyFinishedListener)new PixelCopy.OnPixelCopyFinishedListener(){

                public void onPixelCopyFinished(int copyResult) {
                    if (copyResult == 0) {
                        listener.onSurfaceBitmapReady(bitmap);
                    } else {
                        listener.onSurfaceBitmapError("Couldn't create bitmap of the SurfaceView");
                    }
                    handlerThread.quitSafely();
                }
            }, (Handler)new Handler(handlerThread.getLooper()));
        } else {
            listener.onSurfaceBitmapError("Saving an image of a SurfaceView is only supported for API 24 and above");
        }
    }

    static interface PixelCopyListener {
        public void onSurfaceBitmapReady(Bitmap var1);

        public void onSurfaceBitmapError(String var1);
    }
}

