/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.quickshot;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import java.io.File;

class QuickShotUtils {
    QuickShotUtils() {
    }

    static String getMimeType(String src) {
        if ((src = src.substring(1)).equals("jpg")) {
            src = "jpeg";
        }
        return "image" + File.separator + src;
    }

    static boolean isAndroidQ() {
        return Build.VERSION.SDK_INT >= 29;
    }

    private Bitmap generateLongBitmap(RecyclerView recyclerView) {
        int itemCount = recyclerView.getAdapter().getItemCount();
        RecyclerView.ViewHolder viewHolder = recyclerView.getAdapter().createViewHolder((ViewGroup)recyclerView, 0);
        viewHolder.itemView.measure(View.MeasureSpec.makeMeasureSpec((int)recyclerView.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        int measuredItemHeight = viewHolder.itemView.getMeasuredHeight();
        int measuredItemWidth = viewHolder.itemView.getMeasuredWidth();
        viewHolder.itemView.layout(0, 0, measuredItemWidth, measuredItemHeight);
        Bitmap recyclerViewBitmap = Bitmap.createBitmap((int)recyclerView.getMeasuredWidth(), (int)(measuredItemHeight * itemCount), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(recyclerViewBitmap);
        if (recyclerView.getBackground() != null) {
            Drawable drawable = recyclerView.getBackground().mutate();
            drawable.setBounds(measuredItemWidth, measuredItemHeight * itemCount, 0, 0);
            drawable.draw(canvas);
        }
        int viewHolderTopPadding = 0;
        for (int i = 0; i < itemCount; ++i) {
            recyclerView.getAdapter().onBindViewHolder(viewHolder, i);
            viewHolder.itemView.setDrawingCacheEnabled(true);
            viewHolder.itemView.buildDrawingCache();
            canvas.drawBitmap(viewHolder.itemView.getDrawingCache(), 0.0f, (float)viewHolderTopPadding, null);
            viewHolderTopPadding += measuredItemHeight;
            viewHolder.itemView.setDrawingCacheEnabled(false);
            viewHolder.itemView.destroyDrawingCache();
        }
        return recyclerViewBitmap;
    }
}

