/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.quickshot;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.util.Log;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.muddzdev.quickshot.PixelCopyHelper;
import com.muddzdev.quickshot.QuickShotUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;

public class QuickShot {
    private static final String TAG = QuickShot.class.getSimpleName();
    private static final String EXTENSION_JPG = ".jpg";
    private static final String EXTENSION_PNG = ".png";
    private static final String EXTENSION_NOMEDIA = ".nomedia";
    private static final int JPG_MAX_QUALITY = 100;
    private QuickShotListener listener;
    private int jpgQuality = 100;
    private String fileExtension = ".jpg";
    private String filename = String.valueOf(System.currentTimeMillis());
    private String path;
    private boolean saveInternal;
    private Bitmap bitmap;
    private View view;

    private QuickShot(@NonNull View view) {
        this.view = view;
    }

    private QuickShot(@NonNull Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public static QuickShot of(@NonNull View view) {
        return new QuickShot(view);
    }

    public static QuickShot of(@NonNull Bitmap bitmap) {
        return new QuickShot(bitmap);
    }

    public QuickShot setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public QuickShot setPath(String path) {
        this.path = path;
        return this;
    }

    @RequiresApi(value=29)
    public QuickShot setInternalPath(String path) {
        this.path = path;
        this.saveInternal = true;
        return this;
    }

    public QuickShot setResultListener(QuickShotListener listener) {
        this.listener = listener;
        return this;
    }

    private void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public QuickShot toJPG() {
        this.jpgQuality = 100;
        this.setFileExtension(EXTENSION_JPG);
        return this;
    }

    public QuickShot toJPG(int jpgQuality) {
        this.jpgQuality = jpgQuality;
        this.setFileExtension(EXTENSION_JPG);
        return this;
    }

    public QuickShot toPNG() {
        this.setFileExtension(EXTENSION_PNG);
        return this;
    }

    public QuickShot toNomedia() {
        this.setFileExtension(EXTENSION_NOMEDIA);
        return this;
    }

    private Context getAppContext() {
        if (this.view == null) {
            throw new NullPointerException("Attempt to save the view failed: view was null");
        }
        return this.view.getContext().getApplicationContext();
    }

    private Bitmap getBitmap() {
        if (this.bitmap != null) {
            return this.bitmap;
        }
        if (this.view instanceof TextureView) {
            this.bitmap = ((TextureView)this.view).getBitmap();
            Canvas canvas = new Canvas(this.bitmap);
            this.view.draw(canvas);
            canvas.setBitmap(null);
            return this.bitmap;
        }
        this.bitmap = Bitmap.createBitmap((int)this.view.getWidth(), (int)this.view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.bitmap);
        this.view.draw(canvas);
        canvas.setBitmap(null);
        return this.bitmap;
    }

    public void save() throws NullPointerException {
        if (this.view instanceof SurfaceView) {
            PixelCopyHelper.getSurfaceBitmap((SurfaceView)this.view, new PixelCopyHelper.PixelCopyListener(){

                @Override
                public void onSurfaceBitmapReady(Bitmap surfaceBitmap) {
                    new BitmapSaver(QuickShot.this.getAppContext(), surfaceBitmap, QuickShot.this.saveInternal, QuickShot.this.path, QuickShot.this.filename, QuickShot.this.fileExtension, QuickShot.this.jpgQuality, QuickShot.this.listener).execute(new Void[0]);
                }

                @Override
                public void onSurfaceBitmapError() {
                    if (QuickShot.this.listener != null) {
                        QuickShot.this.listener.onQuickShotFailed();
                    }
                }
            });
        } else {
            new BitmapSaver(this.getAppContext(), this.getBitmap(), this.saveInternal, this.path, this.filename, this.fileExtension, this.jpgQuality, this.listener).execute(new Void[0]);
        }
    }

    static class BitmapSaver
    extends AsyncTask<Void, Void, Void> {
        private final WeakReference<Context> weakContext;
        private Handler handler = new Handler(Looper.getMainLooper());
        private QuickShotListener listener;
        private Bitmap bitmap;
        private String path;
        private boolean saveInternal;
        private String filename;
        private String fileExtension;
        private int jpgQuality;
        private File file;

        BitmapSaver(Context context, Bitmap bitmap, boolean saveInternal, String path, String filename, String fileExtension, int jpgQuality, QuickShotListener listener) {
            this.weakContext = new WeakReference<Context>(context);
            this.bitmap = bitmap;
            this.saveInternal = saveInternal;
            this.path = path;
            this.filename = filename;
            this.fileExtension = fileExtension;
            this.jpgQuality = jpgQuality;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void save() {
            if (this.path == null) {
                this.path = Environment.getExternalStorageDirectory() + File.separator + Environment.DIRECTORY_PICTURES;
            }
            File directory = new File(this.path);
            directory.mkdirs();
            this.file = new File(directory, this.filename + this.fileExtension);
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));){
                switch (this.fileExtension) {
                    case ".jpg": {
                        this.bitmap.compress(Bitmap.CompressFormat.JPEG, this.jpgQuality, (OutputStream)out);
                        return;
                    }
                    case ".png": {
                        this.bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)out);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.cancel(true);
                return;
            }
            finally {
                this.bitmap.recycle();
                this.bitmap = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void saveScoopedStorage() {
            String directory = Environment.DIRECTORY_PICTURES;
            directory = this.path != null ? directory + File.separator + this.path : directory;
            Log.d((String)TAG, (String)directory);
            ContentResolver resolver = ((Context)this.weakContext.get()).getContentResolver();
            ContentValues contentValues = new ContentValues();
            contentValues.put("_display_name", this.filename);
            contentValues.put("mime_type", QuickShotUtils.getMimeType(this.fileExtension));
            contentValues.put("relative_path", directory);
            Uri imageUri = resolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
            if (imageUri == null) {
                Log.e((String)TAG, (String)"Couldn't save image: ContentResolver returned a null Uri");
                return;
            }
            this.file = new File(directory, this.filename + this.fileExtension);
            try (OutputStream out = resolver.openOutputStream(imageUri);){
                switch (this.fileExtension) {
                    case ".jpg": {
                        this.bitmap.compress(Bitmap.CompressFormat.JPEG, this.jpgQuality, out);
                        return;
                    }
                    case ".png": {
                        this.bitmap.compress(Bitmap.CompressFormat.PNG, 0, out);
                        return;
                    }
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.cancel(true);
                return;
            }
            finally {
                this.bitmap.recycle();
                this.bitmap = null;
            }
        }

        protected void onCancelled() {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        BitmapSaver.this.listener.onQuickShotFailed();
                    }
                });
            }
        }

        protected Void doInBackground(Void ... voids) {
            if (QuickShotUtils.isAndroidQ() && !this.saveInternal) {
                this.saveScoopedStorage();
            } else {
                this.save();
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            if (this.listener != null && this.file != null) {
                if (QuickShotUtils.isAndroidQ()) {
                    this.listener.onQuickShotSuccess(this.file.getAbsolutePath());
                } else if (this.file.exists()) {
                    MediaScannerConnection.scanFile((Context)((Context)this.weakContext.get()), (String[])new String[]{this.file.getAbsolutePath()}, null, null);
                    this.listener.onQuickShotSuccess(this.file.getAbsolutePath());
                }
            } else if (this.listener != null) {
                this.listener.onQuickShotFailed();
            }
        }
    }

    public static interface QuickShotListener {
        public void onQuickShotSuccess(String var1);

        public void onQuickShotFailed();
    }
}

