/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.pixelshot;

import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.PixelCopy;
import android.view.SurfaceView;
import androidx.annotation.NonNull;
import com.muddzdev.pixelshot.PixelShot;

class PixelCopyHelper {
    PixelCopyHelper() {
    }

    public static void getSurfaceBitmap(@NonNull SurfaceView surfaceView, final @NonNull PixelCopyListener listener) {
        final Bitmap bitmap = Bitmap.createBitmap((int)surfaceView.getWidth(), (int)surfaceView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        final HandlerThread handlerThread = new HandlerThread(PixelCopyHelper.class.getSimpleName());
        handlerThread.start();
        if (Build.VERSION.SDK_INT >= 24) {
            PixelCopy.request((SurfaceView)surfaceView, (Bitmap)bitmap, (PixelCopy.OnPixelCopyFinishedListener)new PixelCopy.OnPixelCopyFinishedListener(){

                public void onPixelCopyFinished(int copyResult) {
                    if (copyResult == 0) {
                        listener.onSurfaceBitmapReady(bitmap);
                    } else {
                        listener.onSurfaceBitmapError();
                    }
                    handlerThread.quitSafely();
                }
            }, (Handler)new Handler(handlerThread.getLooper()));
        } else {
            Log.d((String)PixelShot.class.getSimpleName(), (String)"Saving an image of a SurfaceView is only supported from API 24");
        }
    }

    static interface PixelCopyListener {
        public void onSurfaceBitmapReady(Bitmap var1);

        public void onSurfaceBitmapError();
    }
}

