/*
 * Decompiled with CFR 0.152.
 */
package com.muddzdev.pixelshot;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import com.muddzdev.pixelshot.PixelCopyHelper;
import com.muddzdev.pixelshot.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;

public class PixelShot {
    private static final String TAG = PixelShot.class.getSimpleName();
    private static final String EXTENSION_JPG = ".jpg";
    private static final String EXTENSION_PNG = ".png";
    private static final String EXTENSION_NOMEDIA = ".nomedia";
    private static final int JPG_MAX_QUALITY = 100;
    private String path = Environment.DIRECTORY_PICTURES;
    private String filename = String.valueOf(System.currentTimeMillis());
    private String fileExtension = ".jpg";
    private int jpgQuality = 100;
    private PixelShotListener listener;
    private View view;

    private PixelShot(@NonNull View view) {
        this.view = view;
    }

    public static PixelShot of(@NonNull View view) {
        return new PixelShot(view);
    }

    public PixelShot setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public PixelShot setPath(String path) {
        this.path = path;
        return this;
    }

    public PixelShot setResultListener(PixelShotListener listener) {
        this.listener = listener;
        return this;
    }

    public PixelShot toJPG() {
        this.jpgQuality = 100;
        this.setFileExtension(EXTENSION_JPG);
        return this;
    }

    public PixelShot toJPG(int jpgQuality) {
        this.jpgQuality = jpgQuality;
        this.setFileExtension(EXTENSION_JPG);
        return this;
    }

    public PixelShot toPNG() {
        this.setFileExtension(EXTENSION_PNG);
        return this;
    }

    public PixelShot toNomedia() {
        this.setFileExtension(EXTENSION_NOMEDIA);
        return this;
    }

    public void save() throws NullPointerException {
        if (!Utils.isExternalStorageReady()) {
            Log.d((String)TAG, (String)"Storage was not ready for use");
            return;
        }
        if (!Utils.isPermissionGranted(this.getAppContext())) {
            Log.d((String)TAG, (String)"Permission WRITE_EXTERNAL_STORAGE was not granted");
            return;
        }
        if (this.view instanceof SurfaceView) {
            PixelCopyHelper.getSurfaceBitmap((SurfaceView)this.view, new PixelCopyHelper.PixelCopyListener(){

                @Override
                public void onSurfaceBitmapReady(Bitmap surfaceBitmap) {
                    new BitmapSaver(PixelShot.this.getAppContext(), surfaceBitmap, PixelShot.this.path, PixelShot.this.filename, PixelShot.this.fileExtension, PixelShot.this.jpgQuality, PixelShot.this.listener).execute(new Void[0]);
                }

                @Override
                public void onSurfaceBitmapError() {
                    Log.d((String)TAG, (String)"Couldn't create a bitmap of the SurfaceView");
                    if (PixelShot.this.listener != null) {
                        PixelShot.this.listener.onPixelShotFailed();
                    }
                }
            });
        } else {
            new BitmapSaver(this.getAppContext(), this.getViewBitmap(), this.path, this.filename, this.fileExtension, this.jpgQuality, this.listener).execute(new Void[0]);
        }
    }

    private void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    private Context getAppContext() {
        if (this.view == null) {
            throw new NullPointerException("The provided View was null");
        }
        return this.view.getContext().getApplicationContext();
    }

    private Bitmap getViewBitmap() {
        if (this.view instanceof TextureView) {
            Bitmap bitmap = ((TextureView)this.view).getBitmap();
            Canvas canvas = new Canvas(bitmap);
            this.view.draw(canvas);
            canvas.setBitmap(null);
            return bitmap;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.view.getWidth(), (int)this.view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        this.view.draw(canvas);
        canvas.setBitmap(null);
        return bitmap;
    }

    static class BitmapSaver
    extends AsyncTask<Void, Void, Void>
    implements MediaScannerConnection.OnScanCompletedListener {
        private final WeakReference<Context> weakContext;
        private Handler handler = new Handler(Looper.getMainLooper());
        private Bitmap bitmap;
        private String path;
        private String filename;
        private String fileExtension;
        private int jpgQuality;
        private PixelShotListener listener;
        private File file;

        BitmapSaver(Context context, Bitmap bitmap, String path, String filename, String fileExtension, int jpgQuality, PixelShotListener listener) {
            this.weakContext = new WeakReference<Context>(context);
            this.bitmap = bitmap;
            this.path = path;
            this.filename = filename;
            this.fileExtension = fileExtension;
            this.jpgQuality = jpgQuality;
            this.listener = listener;
        }

        private void cancelTask() {
            this.cancel(true);
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        BitmapSaver.this.listener.onPixelShotFailed();
                    }
                });
            }
        }

        /*
         * Unable to fully structure code
         */
        protected Void doInBackground(Void ... voids) {
            directory = new File(Environment.getExternalStorageDirectory(), this.path);
            if (!directory.exists() && !directory.mkdirs()) {
                this.cancelTask();
                return null;
            }
            this.file = new File(directory, this.filename + this.fileExtension);
            try {
                out = new BufferedOutputStream(new FileOutputStream(this.file));
                var4_5 = null;
                try {
                    var5_6 = this.fileExtension;
                    var6_9 = -1;
                    switch (var5_6.hashCode()) {
                        case 1475827: {
                            if (!var5_6.equals(".jpg")) break;
                            var6_9 = 0;
                            break;
                        }
                        case 1481531: {
                            if (!var5_6.equals(".png")) break;
                            var6_9 = 1;
                        }
                    }
                    switch (var6_9) {
                        case 0: {
                            this.bitmap.compress(Bitmap.CompressFormat.JPEG, this.jpgQuality, (OutputStream)out);
                            ** break;
lbl25:
                            // 1 sources

                            break;
                        }
                        case 1: {
                            this.bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)out);
                            break;
                        }
                        ** default:
lbl31:
                        // 1 sources

                        break;
                    }
                }
                catch (Throwable var5_8) {
                    var4_5 = var5_8;
                    throw var5_8;
                }
                finally {
                    if (out != null) {
                        if (var4_5 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable var5_7) {
                                var4_5.addSuppressed(var5_7);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.cancelTask();
            }
            this.bitmap.recycle();
            this.bitmap = null;
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            MediaScannerConnection.scanFile((Context)((Context)this.weakContext.get()), (String[])new String[]{this.file.getPath()}, null, (MediaScannerConnection.OnScanCompletedListener)this);
            this.weakContext.clear();
        }

        public void onScanCompleted(final String path, final Uri uri) {
            if (this.listener != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (uri != null) {
                            Log.i((String)TAG, (String)("Saved image to path: " + path));
                            Log.i((String)TAG, (String)("Saved image to URI: " + uri));
                            BitmapSaver.this.listener.onPixelShotSuccess(path);
                        } else {
                            BitmapSaver.this.listener.onPixelShotFailed();
                        }
                    }
                });
            }
        }
    }

    public static interface PixelShotListener {
        public void onPixelShotSuccess(String var1);

        public void onPixelShotFailed();
    }
}

