/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpAccessor;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestTemplate
extends HttpAccessor
implements RestOperations {
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)RestTemplate.class.getClassLoader());
    private static final boolean jacksonPresent = ClassUtils.isPresent((String)"org.codehaus.jackson.map.ObjectMapper", (ClassLoader)RestTemplate.class.getClassLoader()) && ClassUtils.isPresent((String)"org.codehaus.jackson.JsonGenerator", (ClassLoader)RestTemplate.class.getClassLoader());
    private final ResponseExtractor<HttpHeaders> headersExtractor = new HeadersExtractor();
    private List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private ResponseErrorHandler errorHandler = new DefaultResponseErrorHandler();

    public RestTemplate() {
        this.messageConverters.add(new ByteArrayHttpMessageConverter());
        this.messageConverters.add(new StringHttpMessageConverter());
        this.messageConverters.add(new FormHttpMessageConverter());
        this.messageConverters.add(new SourceHttpMessageConverter());
        if (jaxb2Present) {
            this.messageConverters.add(new Jaxb2RootElementHttpMessageConverter());
        }
        if (jacksonPresent) {
            this.messageConverters.add(new MappingJacksonHttpMessageConverter());
        }
    }

    public RestTemplate(ClientHttpRequestFactory requestFactory) {
        this();
        this.setRequestFactory(requestFactory);
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Assert.notEmpty(messageConverters, (String)"'messageConverters' must not be empty");
        this.messageConverters = messageConverters;
    }

    public List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, (String)"'errorHandler' must not be null");
        this.errorHandler = errorHandler;
    }

    public ResponseErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public <T> T getForObject(String url, Class<T> responseType, String ... urlVariables) throws RestClientException {
        AcceptHeaderRequestCallback requestCallback = new AcceptHeaderRequestCallback(responseType, null, null);
        HttpMessageConverterExtractor<T> responseExtractor = new HttpMessageConverterExtractor<T>(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, urlVariables);
    }

    @Override
    public <T> T getForObject(String url, Class<T> responseType, Map<String, String> urlVariables) throws RestClientException {
        AcceptHeaderRequestCallback requestCallback = new AcceptHeaderRequestCallback(responseType, null, null);
        HttpMessageConverterExtractor<T> responseExtractor = new HttpMessageConverterExtractor<T>(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, urlVariables);
    }

    @Override
    public <T> T getForObject(URI url, Class<T> responseType) throws RestClientException {
        AcceptHeaderRequestCallback requestCallback = new AcceptHeaderRequestCallback(responseType, null, null);
        HttpMessageConverterExtractor<T> responseExtractor = new HttpMessageConverterExtractor<T>(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.GET, requestCallback, responseExtractor);
    }

    @Override
    public HttpHeaders headForHeaders(String url, String ... urlVariables) throws RestClientException {
        return this.execute(url, HttpMethod.HEAD, null, this.headersExtractor, urlVariables);
    }

    @Override
    public HttpHeaders headForHeaders(String url, Map<String, String> urlVariables) throws RestClientException {
        return this.execute(url, HttpMethod.HEAD, null, this.headersExtractor, urlVariables);
    }

    @Override
    public HttpHeaders headForHeaders(URI url) throws RestClientException {
        return this.execute(url, HttpMethod.HEAD, null, this.headersExtractor);
    }

    @Override
    public URI postForLocation(String url, Object request, String ... urlVariables) throws RestClientException {
        PostPutCallback requestCallback = new PostPutCallback(request);
        HttpHeaders headers = this.execute(url, HttpMethod.POST, requestCallback, this.headersExtractor, urlVariables);
        return headers.getLocation();
    }

    @Override
    public URI postForLocation(String url, Object request, Map<String, String> urlVariables) throws RestClientException {
        PostPutCallback requestCallback = new PostPutCallback(request);
        HttpHeaders headers = this.execute(url, HttpMethod.POST, requestCallback, this.headersExtractor, urlVariables);
        return headers.getLocation();
    }

    @Override
    public URI postForLocation(URI url, Object request) throws RestClientException {
        PostPutCallback requestCallback = new PostPutCallback(request);
        HttpHeaders headers = this.execute(url, HttpMethod.POST, requestCallback, this.headersExtractor);
        return headers.getLocation();
    }

    @Override
    public <T> T postForObject(String url, Object request, Class<T> responseType, String ... uriVariables) throws RestClientException {
        PostPutCallback requestCallback = new PostPutCallback(request, responseType);
        HttpMessageConverterExtractor<T> responseExtractor = new HttpMessageConverterExtractor<T>(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.POST, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    public <T> T postForObject(String url, Object request, Class<T> responseType, Map<String, String> uriVariables) throws RestClientException {
        PostPutCallback requestCallback = new PostPutCallback(request, responseType);
        HttpMessageConverterExtractor<T> responseExtractor = new HttpMessageConverterExtractor<T>(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.POST, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    public <T> T postForObject(URI url, Object request, Class<T> responseType) throws RestClientException {
        PostPutCallback requestCallback = new PostPutCallback(request, responseType);
        HttpMessageConverterExtractor<T> responseExtractor = new HttpMessageConverterExtractor<T>(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.POST, requestCallback, responseExtractor);
    }

    @Override
    public void put(String url, Object request, String ... urlVariables) throws RestClientException {
        PostPutCallback requestCallback = new PostPutCallback(request);
        this.execute(url, HttpMethod.PUT, requestCallback, null, urlVariables);
    }

    @Override
    public void put(String url, Object request, Map<String, String> urlVariables) throws RestClientException {
        PostPutCallback requestCallback = new PostPutCallback(request);
        this.execute(url, HttpMethod.PUT, requestCallback, null, urlVariables);
    }

    @Override
    public void put(URI url, Object request) throws RestClientException {
        PostPutCallback requestCallback = new PostPutCallback(request);
        this.execute(url, HttpMethod.PUT, requestCallback, null);
    }

    @Override
    public void delete(String url, String ... urlVariables) throws RestClientException {
        this.execute(url, HttpMethod.DELETE, null, null, urlVariables);
    }

    @Override
    public void delete(String url, Map<String, String> urlVariables) throws RestClientException {
        this.execute(url, HttpMethod.DELETE, null, null, urlVariables);
    }

    @Override
    public void delete(URI url) throws RestClientException {
        this.execute(url, HttpMethod.DELETE, null, null);
    }

    @Override
    public Set<HttpMethod> optionsForAllow(String url, String ... urlVariables) throws RestClientException {
        HttpHeaders headers = this.execute(url, HttpMethod.OPTIONS, null, this.headersExtractor, urlVariables);
        return headers.getAllow();
    }

    @Override
    public Set<HttpMethod> optionsForAllow(String url, Map<String, String> urlVariables) throws RestClientException {
        HttpHeaders headers = this.execute(url, HttpMethod.OPTIONS, null, this.headersExtractor, urlVariables);
        return headers.getAllow();
    }

    @Override
    public Set<HttpMethod> optionsForAllow(URI url) throws RestClientException {
        HttpHeaders headers = this.execute(url, HttpMethod.OPTIONS, null, this.headersExtractor);
        return headers.getAllow();
    }

    @Override
    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, String ... urlVariables) throws RestClientException {
        UriTemplate uriTemplate = new UriTemplate(url);
        URI expanded = uriTemplate.expand(urlVariables);
        return this.doExecute(expanded, method, requestCallback, responseExtractor);
    }

    @Override
    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Map<String, String> urlVariables) throws RestClientException {
        UriTemplate uriTemplate = new UriTemplate(url);
        URI expanded = uriTemplate.expand(urlVariables);
        return this.doExecute(expanded, method, requestCallback, responseExtractor);
    }

    @Override
    public <T> T execute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        return this.doExecute(url, method, requestCallback, responseExtractor);
    }

    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        Assert.notNull((Object)url, (String)"'url' must not be null");
        Assert.notNull((Object)((Object)method), (String)"'method' must not be null");
        ClientHttpResponse response = null;
        try {
            ClientHttpRequest request = this.createRequest(url, method);
            if (requestCallback != null) {
                requestCallback.doWithRequest(request);
            }
            response = request.execute();
            if (!this.getErrorHandler().hasError(response)) {
                this.logResponseStatus(method, url, response);
            } else {
                this.handleResponseError(method, url, response);
            }
            if (responseExtractor != null) {
                T t = responseExtractor.extractData(response);
                return t;
            }
            return null;
        }
        catch (IOException ex) {
            throw new ResourceAccessException("I/O error: " + ex.getMessage(), ex);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    private void logResponseStatus(HttpMethod method, URI url, ClientHttpResponse response) {
        if (this.logger.isDebugEnabled()) {
            try {
                this.logger.debug((Object)(String.valueOf(method.name()) + " request for \"" + url + "\" resulted in " + (Object)((Object)response.getStatusCode()) + " (" + response.getStatusText() + ")"));
            }
            catch (IOException iOException) {}
        }
    }

    private void handleResponseError(HttpMethod method, URI url, ClientHttpResponse response) throws IOException {
        if (this.logger.isWarnEnabled()) {
            try {
                this.logger.warn((Object)(String.valueOf(method.name()) + " request for \"" + url + "\" resulted in " + (Object)((Object)response.getStatusCode()) + " (" + response.getStatusText() + "); invoking error handler"));
            }
            catch (IOException iOException) {}
        }
        this.getErrorHandler().handleError(response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AcceptHeaderRequestCallback<T>
    implements RequestCallback {
        private final Class<T> responseType;

        private AcceptHeaderRequestCallback() {
            this.responseType = null;
        }

        private AcceptHeaderRequestCallback(Class<T> responseType) {
            this.responseType = responseType;
        }

        @Override
        public void doWithRequest(ClientHttpRequest request) throws IOException {
            if (this.responseType != null) {
                ArrayList<MediaType> allSupportedMediaTypes = new ArrayList<MediaType>();
                for (HttpMessageConverter<?> messageConverter : RestTemplate.this.getMessageConverters()) {
                    if (!messageConverter.canRead(this.responseType, null)) continue;
                    List<MediaType> supportedMediaTypes = messageConverter.getSupportedMediaTypes();
                    for (MediaType supportedMediaType : supportedMediaTypes) {
                        if (supportedMediaType.getCharSet() != null) {
                            supportedMediaType = new MediaType(supportedMediaType.getType(), supportedMediaType.getSubtype());
                        }
                        allSupportedMediaTypes.add(supportedMediaType);
                    }
                }
                if (!allSupportedMediaTypes.isEmpty()) {
                    Collections.sort(allSupportedMediaTypes);
                    request.getHeaders().setAccept(allSupportedMediaTypes);
                }
            }
        }

        /* synthetic */ AcceptHeaderRequestCallback(Class clazz, AcceptHeaderRequestCallback acceptHeaderRequestCallback, AcceptHeaderRequestCallback acceptHeaderRequestCallback2) {
            this(clazz);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HeadersExtractor
    implements ResponseExtractor<HttpHeaders> {
        private HeadersExtractor() {
        }

        @Override
        public HttpHeaders extractData(ClientHttpResponse response) throws IOException {
            return response.getHeaders();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PostPutCallback<T>
    extends AcceptHeaderRequestCallback<T> {
        private final Object requestBody;
        private final MediaType requestContentType;

        private PostPutCallback(Object requestBody) {
            this.requestBody = requestBody;
            this.requestContentType = null;
        }

        private PostPutCallback(Object requestBody, Class<T> responseType) {
            super(responseType);
            this.requestBody = requestBody;
            this.requestContentType = null;
        }

        private PostPutCallback(Object requestBody, MediaType requestContentType, Class<T> responseType) {
            super(responseType);
            this.requestBody = requestBody;
            this.requestContentType = requestContentType;
        }

        @Override
        public void doWithRequest(ClientHttpRequest httpRequest) throws IOException {
            super.doWithRequest(httpRequest);
            if (this.requestBody != null) {
                Class<?> requestType = this.requestBody.getClass();
                for (HttpMessageConverter<?> messageConverter : RestTemplate.this.getMessageConverters()) {
                    if (!messageConverter.canWrite(requestType, this.requestContentType)) continue;
                    messageConverter.write(this.requestBody, this.requestContentType, httpRequest);
                    return;
                }
                String message = "Could not write request: no suitable HttpMessageConverter found for request type [" + requestType.getName() + "]";
                if (this.requestContentType != null) {
                    message = String.valueOf(message) + " and content type [" + this.requestContentType + "]";
                }
                throw new RestClientException(message);
            }
            httpRequest.getHeaders().setContentLength(0L);
        }
    }
}

