/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.annotation.support;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerMethodResolver {
    private final Set<Method> handlerMethods = new LinkedHashSet<Method>();
    private final Set<Method> initBinderMethods = new LinkedHashSet<Method>();
    private final Set<Method> modelAttributeMethods = new LinkedHashSet<Method>();
    private RequestMapping typeLevelMapping;
    private boolean sessionAttributesFound;
    private final Set<String> sessionAttributeNames = new HashSet<String>();
    private final Set<Class> sessionAttributeTypes = new HashSet<Class>();
    private final Set<String> actualSessionAttributeNames = Collections.synchronizedSet(new HashSet(4));

    public void init(Class<?> handlerType) {
        Class<?>[] handlerTypes;
        Class<?>[] classArray;
        if (Proxy.isProxyClass(handlerType)) {
            classArray = handlerType.getInterfaces();
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = handlerType;
        }
        Class<?>[] classArray3 = handlerTypes = classArray;
        int n = handlerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            final Class<?> currentHandlerType = classArray3[n2];
            ReflectionUtils.doWithMethods(currentHandlerType, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)currentHandlerType);
                    if (HandlerMethodResolver.this.isHandlerMethod(method)) {
                        HandlerMethodResolver.this.handlerMethods.add(specificMethod);
                    } else if (method.isAnnotationPresent(InitBinder.class)) {
                        HandlerMethodResolver.this.initBinderMethods.add(specificMethod);
                    } else if (method.isAnnotationPresent(ModelAttribute.class)) {
                        HandlerMethodResolver.this.modelAttributeMethods.add(specificMethod);
                    }
                }
            });
            ++n2;
        }
        this.typeLevelMapping = (RequestMapping)AnnotationUtils.findAnnotation(handlerType, RequestMapping.class);
        SessionAttributes sessionAttributes = handlerType.getAnnotation(SessionAttributes.class);
        boolean bl = this.sessionAttributesFound = sessionAttributes != null;
        if (this.sessionAttributesFound) {
            this.sessionAttributeNames.addAll((Collection<String>)Arrays.asList(sessionAttributes.value()));
            this.sessionAttributeTypes.addAll((Collection<Class>)Arrays.asList(sessionAttributes.types()));
        }
    }

    protected boolean isHandlerMethod(Method method) {
        return method.isAnnotationPresent(RequestMapping.class);
    }

    public final boolean hasHandlerMethods() {
        return !this.handlerMethods.isEmpty();
    }

    public final Set<Method> getHandlerMethods() {
        return this.handlerMethods;
    }

    public final Set<Method> getInitBinderMethods() {
        return this.initBinderMethods;
    }

    public final Set<Method> getModelAttributeMethods() {
        return this.modelAttributeMethods;
    }

    public boolean hasTypeLevelMapping() {
        return this.typeLevelMapping != null;
    }

    public RequestMapping getTypeLevelMapping() {
        return this.typeLevelMapping;
    }

    public boolean hasSessionAttributes() {
        return this.sessionAttributesFound;
    }

    public boolean isSessionAttribute(String attrName, Class attrType) {
        if (this.sessionAttributeNames.contains(attrName) || this.sessionAttributeTypes.contains(attrType)) {
            this.actualSessionAttributeNames.add(attrName);
            return true;
        }
        return false;
    }

    public Set<String> getActualSessionAttributeNames() {
        return this.actualSessionAttributeNames;
    }
}

