/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.SyntheticResource;

public class ResourceUtil {
    public static String normalize(String path) {
        if (path.length() == 0) {
            return path;
        }
        int absOffset = path.charAt(0) == '/' ? 0 : 1;
        char[] buf = new char[path.length() + 1 + absOffset];
        if (absOffset == 1) {
            buf[0] = 47;
        }
        path.getChars(0, path.length(), buf, absOffset);
        buf[buf.length - 1] = 47;
        int lastSlash = 0;
        int numDots = 0;
        int bufPos = 0;
        for (int bufIdx = lastSlash; bufIdx < buf.length; ++bufIdx) {
            int nextSlash;
            char c = buf[bufIdx];
            if (c == '/') {
                if (numDots == 2) {
                    if (bufPos == 0) {
                        return null;
                    }
                    while (--bufPos > 0 && buf[bufPos] != '/') {
                    }
                }
                lastSlash = bufIdx;
                numDots = 0;
                continue;
            }
            if (c == '.' && numDots < 2) {
                ++numDots;
                continue;
            }
            for (nextSlash = bufIdx + 1; nextSlash < buf.length && buf[nextSlash] != '/'; ++nextSlash) {
            }
            if (bufPos < lastSlash) {
                int segLen = nextSlash - bufIdx + 1;
                System.arraycopy(buf, lastSlash, buf, bufPos, segLen);
                bufPos += segLen;
            } else {
                bufPos = nextSlash;
            }
            numDots = 0;
            lastSlash = nextSlash;
            bufIdx = nextSlash;
        }
        String resolved = bufPos == 0 && numDots == 0 ? (absOffset == 0 ? "/" : "") : (bufPos - absOffset == path.length() ? path : new String(buf, absOffset, bufPos - absOffset));
        return resolved;
    }

    public static String getParent(String path) {
        if ("/".equals(path)) {
            return null;
        }
        if ((path = ResourceUtil.normalize(path)) == null || "/".equals(path)) {
            return null;
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            return null;
        }
        if (lastSlash == 0) {
            return "/";
        }
        return path.substring(0, lastSlash);
    }

    public static Resource getParent(Resource rsrc) {
        String parentPath = ResourceUtil.getParent(rsrc.getPath());
        if (parentPath == null) {
            return null;
        }
        return rsrc.getResourceResolver().resolve(parentPath);
    }

    public static String getName(Resource rsrc) {
        String name = ResourceUtil.getName(rsrc.getPath());
        return name;
    }

    public static String getName(String path) {
        if ("/".equals(path)) {
            return "";
        }
        if ("/".equals(path = ResourceUtil.normalize(path))) {
            return "";
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static boolean isSyntheticResource(Resource res) {
        return res instanceof SyntheticResource;
    }

    public static boolean isStarResource(Resource res) {
        return res.getPath().endsWith("/*");
    }

    public static boolean isNonExistingResource(Resource res) {
        return "sling:nonexisting".equals(res.getResourceType());
    }
}

