/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.extender.internal.activator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ConcurrentMap;
import org.springframework.osgi.extender.internal.util.concurrent.Counter;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.web.deployer.ContextPathStrategy;
import org.springframework.osgi.web.deployer.OsgiWarDeploymentException;
import org.springframework.osgi.web.deployer.WarDeployer;
import org.springframework.osgi.web.deployer.WarDeployment;
import org.springframework.osgi.web.extender.internal.activator.WarListenerConfiguration;
import org.springframework.osgi.web.extender.internal.scanner.WarScanner;
import org.springframework.scheduling.timer.TimerTaskExecutor;
import org.springframework.util.Assert;

public class WarLoaderListener
implements BundleActivator {
    private static final Log log = LogFactory.getLog((Class)WarLoaderListener.class);
    private BundleContext bundleContext;
    private Version extenderVersion;
    private long bundleId;
    private final ConcurrentMap managedBundles;
    private SynchronousBundleListener warListener;
    private WarScanner warScanner;
    private WarDeployer warDeployer;
    private ContextPathStrategy contextPathStrategy;
    private final DeploymentManager deploymentManager;
    private WarListenerConfiguration configuration;
    private final Object lock = new Object();
    private boolean destroyed = false;

    public WarLoaderListener() {
        this.managedBundles = CollectionFactory.createConcurrentMap((int)16);
        this.deploymentManager = new DeploymentManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final BundleContext context) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.bundleContext = context;
            this.bundleId = this.bundleContext.getBundle().getBundleId();
            this.extenderVersion = OsgiBundleUtils.getBundleVersion((Bundle)context.getBundle());
            this.destroyed = false;
        }
        final boolean trace = log.isTraceEnabled();
        log.info((Object)("Starting [" + this.bundleContext.getBundle().getSymbolicName() + "] bundle v.[" + this.extenderVersion + "]"));
        Thread th = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    WarListenerConfiguration config = new WarListenerConfiguration(WarLoaderListener.this.bundleContext);
                    Object object = WarLoaderListener.this.lock;
                    synchronized (object) {
                        if (!WarLoaderListener.this.destroyed) {
                            WarLoaderListener.this.configuration = config;
                            WarLoaderListener.this.warScanner = WarLoaderListener.this.configuration.getWarScanner();
                            WarLoaderListener.this.warDeployer = WarLoaderListener.this.configuration.getWarDeployer();
                            WarLoaderListener.this.contextPathStrategy = WarLoaderListener.this.configuration.getContextPathStrategy();
                            WarLoaderListener.this.warListener = new WarBundleListener();
                            context.addBundleListener((BundleListener)WarLoaderListener.this.warListener);
                        } else {
                            config.destroy();
                        }
                    }
                    Bundle[] bnds = context.getBundles();
                    for (int i = 0; i < bnds.length; ++i) {
                        Bundle bundle = bnds[i];
                        if (!OsgiBundleUtils.isBundleActive((Bundle)bundle)) continue;
                        if (trace) {
                            log.trace((Object)("Checking if bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + " is a war.."));
                        }
                        WarLoaderListener.this.maybeDeployWar(bundle);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)"Cannot property start Spring DM WebExtender; stopping bundle...", (Throwable)ex);
                    try {
                        context.getBundle().stop();
                    }
                    catch (Exception excep) {
                        log.debug((Object)"Stopping of the extender bundle failed", (Throwable)excep);
                    }
                }
            }
        }, "WebExtender-Init");
        th.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeDeployWar(Bundle bundle) {
        ContextPathStrategy localCPS;
        WarScanner localWarScanner;
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            if (OsgiBundleUtils.isSystemBundle((Bundle)bundle) || bundle.getBundleId() == this.bundleId) {
                return;
            }
        }
        Object object2 = this.lock;
        synchronized (object2) {
            localWarScanner = this.warScanner;
            localCPS = this.contextPathStrategy;
        }
        if (localWarScanner.isWar(bundle)) {
            String contextPath = localCPS.getContextPath(bundle);
            Assert.doesNotContain((String)contextPath, (String)" ", (String)"context path should not contain whitespaces");
            String msg = OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + " is a WAR, scheduling war deployment on context path [" + contextPath + "] (";
            URL webXML = this.getWebXml(bundle);
            msg = webXML != null ? msg + "web.xml found at [" + webXML + "])" : msg + "no web.xml detected)";
            log.info((Object)msg);
            this.managedBundles.put((Object)bundle, (Object)contextPath);
            this.deploymentManager.deployBundle(bundle, contextPath);
        }
    }

    private URL getWebXml(Bundle bundle) {
        Enumeration enm = bundle.findEntries("WEB-INF/", "web.xml", false);
        if (enm != null && enm.hasMoreElements()) {
            return (URL)enm.nextElement();
        }
        return null;
    }

    private void maybeUndeployWar(Bundle bundle) {
        boolean debug = log.isDebugEnabled();
        String contextPath = (String)this.managedBundles.remove((Object)bundle);
        if (contextPath != null) {
            log.info((Object)(OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + " is a WAR, scheduling war undeployment with context path [" + contextPath + "]"));
            this.deploymentManager.undeployBundle(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.destroyed = true;
            if (this.warListener != null) {
                context.removeBundleListener((BundleListener)this.warListener);
                this.warListener = null;
            }
        }
        this.deploymentManager.destroy();
    }

    private class DeploymentManager
    implements DisposableBean {
        private static final long SHUTDOWN_WAIT_TIME = 60000L;
        private final ConcurrentMap bundlesToDeployments = CollectionFactory.createConcurrentMap((int)16);
        private final TimerTaskExecutor executor = new TimerTaskExecutor();
        final Counter onGoingTask = new Counter("ongoing-task");

        public DeploymentManager() {
            this.executor.afterPropertiesSet();
        }

        public void deployBundle(Bundle bundle, String contextPath) {
            this.executor.execute((Runnable)new DeployTask(bundle, contextPath, this.onGoingTask));
        }

        public void undeployBundle(Bundle bundle) {
            this.executor.execute((Runnable)new UndeployTask(bundle, this.onGoingTask));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() throws Exception {
            WarListenerConfiguration localConfig;
            this.executor.destroy();
            Object object = WarLoaderListener.this.lock;
            synchronized (object) {
                localConfig = WarLoaderListener.this.configuration;
            }
            if (localConfig != null) {
                if (localConfig.shouldUndeployWarsAtShutdown()) {
                    final ArrayList bundles = new ArrayList(this.bundlesToDeployments.keySet());
                    StringBuffer bundlesToString = new StringBuffer("\n");
                    Iterator iterator = bundles.iterator();
                    while (iterator.hasNext()) {
                        Bundle bundle = (Bundle)iterator.next();
                        bundlesToString.append("[ ");
                        bundlesToString.append(OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle));
                        bundlesToString.append(" ]\n");
                    }
                    log.info((Object)("Undeploying all deployed bundle wars: {" + bundlesToString.toString() + "}"));
                    Runnable undeployBundlesRunnable = new Runnable(){

                        public void run() {
                            Iterator iterator = bundles.iterator();
                            while (iterator.hasNext()) {
                                Bundle bundle = (Bundle)iterator.next();
                                new UndeployTask(bundle, DeploymentManager.this.onGoingTask).run();
                            }
                            DeploymentManager.this.bundlesToDeployments.clear();
                            localConfig.destroy();
                        }
                    };
                    Thread thread = new Thread(undeployBundlesRunnable, "Spring-DM WebExtender[" + WarLoaderListener.this.extenderVersion + "] war undeployment thread");
                    thread.start();
                } else {
                    if (this.onGoingTask.waitForZero(60000L)) {
                        log.debug((Object)"An on-going deploy/undeploy task did not finish in time; continuing shutdown...");
                    }
                    localConfig.destroy();
                }
            }
        }

        private class UndeployTask
        extends BaseTask {
            public UndeployTask(Bundle bundle, Counter counter) {
                super(bundle, counter);
            }

            public void doRun() {
                WarDeployment deployment = (WarDeployment)DeploymentManager.this.bundlesToDeployments.remove((Object)this.bundle);
                if (deployment != null) {
                    try {
                        deployment.undeploy();
                    }
                    catch (OsgiWarDeploymentException ex) {
                        log.error((Object)("War undeployment of bundle " + this.bundleName + " failed"), (Throwable)ex);
                    }
                }
            }
        }

        private class DeployTask
        extends BaseTask {
            private final String contextPath;

            public DeployTask(Bundle bundle, String contextPath, Counter counter) {
                super(bundle, counter);
                this.contextPath = contextPath;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doRun() {
                try {
                    Object object = WarLoaderListener.this.lock;
                    synchronized (object) {
                        if (WarLoaderListener.this.destroyed) {
                            return;
                        }
                    }
                    WarDeployment deployment = WarLoaderListener.this.warDeployer.deploy(this.bundle, this.contextPath);
                    DeploymentManager.this.bundlesToDeployments.put((Object)this.bundle, (Object)deployment);
                }
                catch (OsgiWarDeploymentException ex) {
                    log.error((Object)("War deployment of bundle " + this.bundleName + " failed"), (Throwable)ex);
                }
            }
        }

        private abstract class BaseTask
        implements Runnable {
            final Bundle bundle;
            final String bundleName;
            final Counter counter;

            public BaseTask(Bundle bundle, Counter counter) {
                this.bundle = bundle;
                this.bundleName = OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle);
                this.counter = counter;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                this.counter.increment();
                boolean trace = log.isTraceEnabled();
                if (trace) {
                    log.trace((Object)("Incrementing work counter for " + this.toString()));
                }
                try {
                    this.doRun();
                }
                finally {
                    this.counter.decrement();
                    if (trace) {
                        log.trace((Object)("Decrementing work counter for " + this.toString()));
                    }
                }
            }

            protected abstract void doRun();
        }
    }

    private class WarBundleListener
    implements SynchronousBundleListener {
        private WarBundleListener() {
        }

        public void bundleChanged(BundleEvent event) {
            Bundle bundle = event.getBundle();
            boolean trace = log.isTraceEnabled();
            switch (event.getType()) {
                case 2: {
                    if (trace) {
                        log.trace((Object)("Processing " + OsgiStringUtils.nullSafeToString((BundleEvent)event) + " event for bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle)));
                    }
                    WarLoaderListener.this.maybeDeployWar(bundle);
                    break;
                }
                case 256: {
                    if (trace) {
                        log.trace((Object)("Processing " + OsgiStringUtils.nullSafeToString((BundleEvent)event) + " event for bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle)));
                    }
                    WarLoaderListener.this.maybeUndeployWar(bundle);
                    break;
                }
            }
        }
    }
}

