/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.deployer.jetty;

import java.io.File;
import java.io.IOException;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.resource.Resource;
import org.mortbay.util.IO;
import org.osgi.framework.Bundle;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.web.deployer.OsgiWarDeploymentException;
import org.springframework.osgi.web.deployer.WarDeployment;
import org.springframework.osgi.web.deployer.WarDeploymentContext;
import org.springframework.osgi.web.deployer.internal.util.Utils;
import org.springframework.osgi.web.deployer.jetty.JettyContextUndeployer;
import org.springframework.osgi.web.deployer.jetty.JettyWarDeployment;
import org.springframework.osgi.web.deployer.support.AbstractWarDeployer;
import org.springframework.util.Assert;

public class JettyWarDeployer
extends AbstractWarDeployer {
    private static final String[] systemClasses = new String[]{"java.", "javax.servlet.", "javax.xml.", "org.mortbay."};
    private static final String[] serverClasses = new String[]{"-org.mortbay.jetty.plus.jaas.", "org.mortbay.jetty."};
    private Server serverService;

    public void setServer(Object server) {
        if (server != null) {
            Assert.isInstanceOf((Class)Server.class, (Object)server, (String)"Invalid Jetty Server given:");
            this.serverService = (Server)server;
        }
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.serverService == null) {
            this.log.info((Object)"No Jetty Server set; looking for one in the OSGi service registry...");
            try {
                this.serverService = (Server)Utils.createServerServiceProxy(this.getBundleContext(), Server.class, null);
                this.log.info((Object)("Found service " + this.serverService));
            }
            catch (RuntimeException ex) {
                this.log.error((Object)"No Jetty Server found, bailing out", (Throwable)ex);
                throw ex;
            }
        }
    }

    protected WarDeployment createDeployment(Bundle bundle, String contextPath) throws Exception {
        WebAppContext wac = this.createJettyWebContext(bundle, contextPath);
        wac.setAttribute(WarDeploymentContext.OSGI_BUNDLE_CONTEXT_ATTRIBUTE, (Object)OsgiBundleUtils.getBundleContext((Bundle)bundle));
        JettyWarDeployment deployment = new JettyWarDeployment(new JettyContextUndeployer(){

            public void undeploy(WebAppContext webAppCtx) throws OsgiWarDeploymentException {
                JettyWarDeployer.this.stopWebAppContext(webAppCtx);
            }
        }, bundle, wac);
        return deployment;
    }

    protected void startDeployment(WarDeployment deployment) throws Exception {
        Assert.isInstanceOf((Class)JettyWarDeployment.class, (Object)deployment, (String)"Wrong type of deployment used");
        this.startWebAppContext(((JettyWarDeployment)deployment).getWebAppContext());
    }

    private WebAppContext createJettyWebContext(Bundle bundle, String contextPath) throws Exception {
        WebAppContext wac = new WebAppContext();
        wac.setServer(this.serverService);
        wac.setWar(OsgiStringUtils.nullSafeName((Bundle)bundle));
        wac.setContextPath(contextPath);
        wac.setCopyWebDir(false);
        wac.setExtractWAR(true);
        Resource rootResource = this.getRootResource(bundle, wac);
        wac.setBaseResource(rootResource);
        wac.setWar(null);
        wac.setSystemClasses(systemClasses);
        wac.setServerClasses(serverClasses);
        wac.setParentLoaderPriority(false);
        wac.setClassLoader((ClassLoader)Utils.createWebAppClassLoader(bundle, Server.class));
        return wac;
    }

    private Resource getRootResource(Bundle bundle, WebAppContext wac) throws Exception {
        File unpackFolder = this.unpackBundle(bundle, wac);
        return Resource.newResource((String)unpackFolder.getCanonicalPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWebAppContext(WebAppContext wac) throws Exception {
        HandlerCollection contexts = this.getJettyContexts();
        Thread current = Thread.currentThread();
        ClassLoader old = current.getContextClassLoader();
        try {
            current.setContextClassLoader(wac.getClassLoader());
            if (contexts != null) {
                contexts.addHandler((Handler)wac);
            }
            wac.start();
            if (contexts != null) {
                contexts.start();
            }
        }
        finally {
            current.setContextClassLoader(old);
        }
    }

    private void stopWebAppContext(WebAppContext wac) throws OsgiWarDeploymentException {
        Resource rootResource = wac.getBaseResource();
        String contextPath = wac.getContextPath();
        String messageEnding = "context [" + contextPath + "] from server " + this.getServerInfo();
        this.log.info((Object)("About to undeploy " + messageEnding));
        HandlerCollection contexts = this.getJettyContexts();
        Thread current = Thread.currentThread();
        ClassLoader old = current.getContextClassLoader();
        try {
            current.setContextClassLoader(wac.getClassLoader());
            wac.stop();
            if (contexts != null) {
                contexts.removeHandler((Handler)wac);
            }
            this.log.info((Object)("Context [" + contextPath + "] undeployed successfully from server " + this.getServerInfo()));
        }
        catch (Exception ex) {
            throw new OsgiWarDeploymentException("Cannot undeploy " + messageEnding, ex);
        }
        finally {
            current.setContextClassLoader(old);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cleaning unpacked folder " + rootResource));
            }
            try {
                IO.delete((File)rootResource.getFile());
            }
            catch (IOException ex) {
                this.log.warn((Object)("Could not clean unpacked folder for " + messageEnding), (Throwable)ex);
            }
        }
    }

    private HandlerCollection getJettyContexts() {
        HandlerCollection contexts = (HandlerCollection)this.serverService.getChildHandlerByClass(ContextHandlerCollection.class);
        if (contexts == null) {
            contexts = (HandlerCollection)this.serverService.getChildHandlerByClass(HandlerCollection.class);
        }
        return contexts;
    }

    private File unpackBundle(Bundle bundle, WebAppContext wac) throws Exception {
        File tmpFile = File.createTempFile("jetty-" + wac.getContextPath().substring(1), ".osgi");
        tmpFile.delete();
        tmpFile.mkdir();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Unpacking bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + " to folder [" + tmpFile.getCanonicalPath() + "] ..."));
        }
        Utils.unpackBundle(bundle, tmpFile);
        return tmpFile;
    }

    protected String getServerInfo() {
        return "Jetty-" + Server.getVersion();
    }
}

