/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class OpDivide
extends Operator {
    public OpDivide(int pos, SpelNodeImpl ... operands) {
        super("/", pos, operands);
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Object operandOne = this.getLeftOperand().getValueInternal(state).getValue();
        Object operandTwo = this.getRightOperand().getValueInternal(state).getValue();
        if (operandOne instanceof Number && operandTwo instanceof Number) {
            Number op1 = (Number)operandOne;
            Number op2 = (Number)operandTwo;
            if (op1 instanceof Double || op2 instanceof Double) {
                return new TypedValue(op1.doubleValue() / op2.doubleValue(), DOUBLE_TYPE_DESCRIPTOR);
            }
            if (op1 instanceof Long || op2 instanceof Long) {
                return new TypedValue(op1.longValue() / op2.longValue(), LONG_TYPE_DESCRIPTOR);
            }
            return new TypedValue(op1.intValue() / op2.intValue(), INTEGER_TYPE_DESCRIPTOR);
        }
        TypedValue result = state.operate(Operation.DIVIDE, operandOne, operandTwo);
        return new TypedValue(result, TypeDescriptor.forObject((Object)result));
    }
}

