/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import org.springframework.core.convert.support.ArrayToArrayConverter;
import org.springframework.core.convert.support.ArrayToCollectionConverter;
import org.springframework.core.convert.support.ArrayToMapConverter;
import org.springframework.core.convert.support.ArrayToObjectConverter;
import org.springframework.core.convert.support.CharacterToNumberFactory;
import org.springframework.core.convert.support.CollectionToArrayConverter;
import org.springframework.core.convert.support.CollectionToCollectionConverter;
import org.springframework.core.convert.support.CollectionToMapConverter;
import org.springframework.core.convert.support.CollectionToObjectConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.IdToEntityConverter;
import org.springframework.core.convert.support.MapToArrayConverter;
import org.springframework.core.convert.support.MapToCollectionConverter;
import org.springframework.core.convert.support.MapToMapConverter;
import org.springframework.core.convert.support.MapToObjectConverter;
import org.springframework.core.convert.support.NumberToCharacterConverter;
import org.springframework.core.convert.support.NumberToNumberConverterFactory;
import org.springframework.core.convert.support.ObjectToArrayConverter;
import org.springframework.core.convert.support.ObjectToCollectionConverter;
import org.springframework.core.convert.support.ObjectToMapConverter;
import org.springframework.core.convert.support.ObjectToObjectGenericConverter;
import org.springframework.core.convert.support.ObjectToStringConverter;
import org.springframework.core.convert.support.StringToBooleanConverter;
import org.springframework.core.convert.support.StringToCharacterConverter;
import org.springframework.core.convert.support.StringToEnumConverterFactory;
import org.springframework.core.convert.support.StringToLocaleConverter;
import org.springframework.core.convert.support.StringToNumberConverterFactory;

public abstract class ConversionServiceFactory {
    public static GenericConversionService createDefaultConversionService() {
        GenericConversionService conversionService = new GenericConversionService();
        ConversionServiceFactory.addDefaultConverters(conversionService);
        return conversionService;
    }

    public static void addDefaultConverters(GenericConversionService conversionService) {
        conversionService.addGenericConverter(new ArrayToArrayConverter(conversionService));
        conversionService.addGenericConverter(new ArrayToCollectionConverter(conversionService));
        conversionService.addGenericConverter(new ArrayToMapConverter(conversionService));
        conversionService.addGenericConverter(new ArrayToObjectConverter(conversionService));
        conversionService.addGenericConverter(new CollectionToCollectionConverter(conversionService));
        conversionService.addGenericConverter(new CollectionToArrayConverter(conversionService));
        conversionService.addGenericConverter(new CollectionToMapConverter(conversionService));
        conversionService.addGenericConverter(new CollectionToObjectConverter(conversionService));
        conversionService.addGenericConverter(new MapToMapConverter(conversionService));
        conversionService.addGenericConverter(new MapToArrayConverter(conversionService));
        conversionService.addGenericConverter(new MapToCollectionConverter(conversionService));
        conversionService.addGenericConverter(new MapToObjectConverter(conversionService));
        conversionService.addGenericConverter(new ObjectToArrayConverter(conversionService));
        conversionService.addGenericConverter(new ObjectToCollectionConverter(conversionService));
        conversionService.addGenericConverter(new ObjectToMapConverter(conversionService));
        conversionService.addConverter(new ObjectToStringConverter());
        conversionService.addConverter(new StringToBooleanConverter());
        conversionService.addConverter(new StringToCharacterConverter());
        conversionService.addConverter(new StringToLocaleConverter());
        conversionService.addConverter(new NumberToCharacterConverter());
        conversionService.addConverterFactory(new StringToNumberConverterFactory());
        conversionService.addConverterFactory(new StringToEnumConverterFactory());
        conversionService.addConverterFactory(new NumberToNumberConverterFactory());
        conversionService.addConverterFactory(new CharacterToNumberFactory());
        conversionService.addGenericConverter(new ObjectToObjectGenericConverter());
        conversionService.addGenericConverter(new IdToEntityConverter(conversionService));
    }
}

