/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Arrays;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.CollectionToMapConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ArrayToMapConverter
implements GenericConverter {
    private final CollectionToMapConverter helperConverter;

    public ArrayToMapConverter(GenericConversionService conversionService) {
        this.helperConverter = new CollectionToMapConverter(conversionService);
    }

    @Override
    public Class<?>[][] getConvertibleTypes() {
        return new Class[][]{{Object[].class, Map.class}};
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.helperConverter.convert(Arrays.asList(ObjectUtils.toObjectArray(source)), sourceType, targetType);
    }
}

