/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDescriptor {
    public static final TypeDescriptor NULL = new TypeDescriptor();
    private Class<?> type;
    private TypeDescriptor elementType;
    private MethodParameter methodParameter;
    private Field field;
    private Annotation[] cachedFieldAnnotations;

    public TypeDescriptor(Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        this.type = type;
    }

    public TypeDescriptor(MethodParameter methodParameter) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        this.methodParameter = methodParameter;
    }

    public TypeDescriptor(Field field) {
        Assert.notNull(field, "Field must not be null");
        this.field = field;
    }

    private TypeDescriptor() {
    }

    private TypeDescriptor(Class<?> collectionType, TypeDescriptor elementType) {
        this.type = collectionType;
        this.elementType = elementType;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.field != null) {
            return this.field.getType();
        }
        if (this.methodParameter != null) {
            return this.methodParameter.getParameterType();
        }
        return null;
    }

    public Class<?> getObjectType() {
        Class<?> type = this.getType();
        return type != null ? ClassUtils.resolvePrimitiveIfNecessary(type) : type;
    }

    public boolean typeEquals(Class<?> type) {
        return ObjectUtils.nullSafeEquals(this.getType(), type);
    }

    public String getName() {
        Class<?> type = this.getType();
        if (type != null) {
            return this.getType().getName();
        }
        return null;
    }

    public boolean isPrimitive() {
        Class<?> type = this.getType();
        return type != null && type.isPrimitive();
    }

    public boolean isArray() {
        Class<?> type = this.getType();
        return type != null && type.isArray();
    }

    public boolean isCollection() {
        return this.isTypeAssignableTo(Collection.class);
    }

    public Class<?> getElementType() {
        return this.getElementTypeDescriptor().getType();
    }

    public TypeDescriptor getElementTypeDescriptor() {
        if (this.elementType != null) {
            return this.elementType;
        }
        if (this.isArray()) {
            return TypeDescriptor.valueOf(this.getArrayComponentType());
        }
        if (this.isCollection()) {
            return TypeDescriptor.valueOf(this.getCollectionElementType());
        }
        return NULL;
    }

    public boolean isMap() {
        return this.isTypeAssignableTo(Map.class);
    }

    public boolean isMapEntryTypeKnown() {
        return this.isMap() && this.getMapKeyType() != null && this.getMapValueType() != null;
    }

    public Class<?> getMapKeyType() {
        if (this.field != null) {
            return GenericCollectionTypeResolver.getMapKeyFieldType(this.field);
        }
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getMapKeyParameterType(this.methodParameter);
        }
        return null;
    }

    public Class<?> getMapValueType() {
        if (this.field != null) {
            return GenericCollectionTypeResolver.getMapValueFieldType(this.field);
        }
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getMapValueParameterType(this.methodParameter);
        }
        return null;
    }

    public TypeDescriptor getMapKeyTypeDescriptor() {
        return TypeDescriptor.valueOf(this.getMapKeyType());
    }

    public TypeDescriptor getMapValueTypeDescriptor() {
        return TypeDescriptor.valueOf(this.getMapValueType());
    }

    public Annotation[] getAnnotations() {
        if (this.field != null) {
            if (this.cachedFieldAnnotations == null) {
                this.cachedFieldAnnotations = this.field.getAnnotations();
            }
            return this.cachedFieldAnnotations;
        }
        if (this.methodParameter != null) {
            return this.methodParameter.getParameterAnnotations();
        }
        return new Annotation[0];
    }

    public Annotation getAnnotation(Class<? extends Annotation> annotationType) {
        Annotation[] annotationArray = this.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().equals(annotationType)) {
                return annotation;
            }
            ++n2;
        }
        return null;
    }

    public boolean isAbstractClass() {
        Class<?> type = this.getType();
        return type != null && !this.getType().isInterface() && Modifier.isAbstract(this.getType().getModifiers());
    }

    public boolean isAssignableValue(Object obj) {
        Class<?> type = this.getType();
        return type != null && ClassUtils.isAssignableValue(this.getType(), obj);
    }

    public boolean isAssignableTo(TypeDescriptor targetType) {
        if (targetType == NULL) {
            return false;
        }
        Class<?> type = this.getType();
        return type != null && ClassUtils.isAssignable(targetType.getType(), type);
    }

    private Class<?> getArrayComponentType() {
        return this.getType().getComponentType();
    }

    private Class<?> getCollectionElementType() {
        if (this.type != null) {
            return GenericCollectionTypeResolver.getCollectionType(this.type);
        }
        if (this.field != null) {
            return GenericCollectionTypeResolver.getCollectionFieldType(this.field);
        }
        return GenericCollectionTypeResolver.getCollectionParameterType(this.methodParameter);
    }

    private boolean isTypeAssignableTo(Class<?> clazz) {
        Class<?> type = this.getType();
        return type != null && ClassUtils.isAssignable(clazz, type);
    }

    public String asString() {
        StringBuffer stringValue = new StringBuffer();
        if (this.isArray()) {
            stringValue.append(this.getArrayComponentType().getName()).append("[]");
        } else {
            Class<?> clazz = this.getType();
            if (clazz == null) {
                return "null";
            }
            stringValue.append(clazz.getName());
            if (this.isCollection()) {
                Class<?> collectionType = this.getCollectionElementType();
                if (collectionType != null) {
                    stringValue.append("<").append(collectionType.getName()).append(">");
                }
            } else if (this.isMap()) {
                Class<?> keyType = this.getMapKeyType();
                Class<?> valType = this.getMapValueType();
                if (keyType != null && valType != null) {
                    stringValue.append("<").append(keyType.getName()).append(",");
                    stringValue.append(valType).append(">");
                }
            }
        }
        return stringValue.toString();
    }

    public String toString() {
        Annotation[] anns;
        if (this == NULL) {
            return "[TypeDescriptor.NULL]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[TypeDescriptor ");
        Annotation[] annotationArray = anns = this.getAnnotations();
        int n = anns.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            builder.append("@").append(ann.annotationType().getName()).append(' ');
            ++n2;
        }
        builder.append(this.getType().getName());
        builder.append("]");
        return builder.toString();
    }

    public static TypeDescriptor valueOf(Class<?> type) {
        return type != null ? new TypeDescriptor(type) : NULL;
    }

    public static TypeDescriptor forObject(Object object) {
        return object == null ? NULL : TypeDescriptor.valueOf(object.getClass());
    }

    public static TypeDescriptor collection(Class<?> type, TypeDescriptor elementType) {
        return new TypeDescriptor(type, elementType);
    }
}

