/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.path;

import com.mtvnet.boxspring.path.ChildPathedBeanFactoryPostProcessor;
import com.mtvnet.boxspring.path.PathedBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.PriorityOrdered;

public class InstantiateSingletonsPostProcessor
extends ChildPathedBeanFactoryPostProcessor
implements PriorityOrdered {
    public static final String DISABLE_BEAN_NAME = "DisableSingletonPreInstantiation";

    public int getOrder() {
        return 2;
    }

    protected boolean addSelfToChild(ConfigurableListableBeanFactory childFactory) {
        return this.singletonInstantiationEnabled((ListableBeanFactory)childFactory);
    }

    protected Object postProcessChildBeanFactory(PathedBeanFactory beanFactory, String beanName) {
        if (this.singletonInstantiationEnabled(beanFactory) && beanFactory instanceof ConfigurableListableBeanFactory) {
            ((ConfigurableListableBeanFactory)beanFactory).preInstantiateSingletons();
        }
        return beanFactory;
    }

    private boolean singletonInstantiationEnabled(ListableBeanFactory beanFactory) {
        return !beanFactory.containsBeanDefinition(DISABLE_BEAN_NAME);
    }
}

