/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.path;

import com.mtvnet.boxspring.util.GentleSystemPropertyUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

class Defaults {
    private static final List<String> CONFIG_LOCATIONS = Arrays.asList("classpath*:META-INF/spring/", "classpath*:META-INF/spring-${application}/", "classpath*:META-INF/spring-${stage}/", "classpath*:META-INF/spring-${mtvi.server.stage}/", "classpath*:META-INF/spring-${instance}/", "classpath*:META-INF/spring-${mtvi.server.instance}/", "classpath*:META-INF/spring-${stage}-${instance}/", "classpath*:META-INF/spring-${mtvi.server.stage}-${mtvi.server.instance}/");
    private static final String[] FILE_NAMES = new String[]{"applicationContext.xml"};

    Defaults() {
    }

    static Resource[] getDefaultRootResources() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
        for (String string : CONFIG_LOCATIONS) {
            try {
                resources.addAll(Arrays.asList(resolver.getResources(GentleSystemPropertyUtils.resolvePlaceholders(string))));
            }
            catch (IOException e) {
            }
            catch (IllegalArgumentException e) {}
        }
        return resources.toArray(new Resource[0]);
    }

    static String[] getDefaultFileNames() {
        return FILE_NAMES;
    }
}

