/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.path;

import com.mtvnet.boxspring.path.Path;
import com.mtvnet.boxspring.path.PathManager;
import java.io.IOException;
import org.springframework.core.io.Resource;

public class DefaultPathManager
implements PathManager {
    public boolean isPath(String name) {
        if (name.contains("/")) {
            Path p = this.parsePath(name);
            if (p.isAbsolute()) {
                return true;
            }
            return !p.getLocalPart().contains(":");
        }
        return false;
    }

    public Path parsePath(String name) {
        return new DefaultPath(name);
    }

    private class DefaultPath
    implements Path {
        private boolean absolute;
        private String childPart;
        private String localPart;
        private String originalName;

        public DefaultPath(String name) {
            this.originalName = name;
            if (name.startsWith("/")) {
                this.absolute = true;
                this.parse(name.substring(1));
            } else {
                this.absolute = false;
                this.parse(name);
            }
        }

        public Resource createRelative(Resource resource) throws IOException {
            return resource.createRelative(this.localPart + "/");
        }

        public String getChildPart() {
            return this.childPart;
        }

        public String getLocalPart() {
            return this.localPart;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public boolean hasChildPart() {
            return this.childPart != null;
        }

        public boolean isAbsolute() {
            return this.absolute;
        }

        public String toString() {
            return this.getOriginalName();
        }

        private void parse(String name) {
            String[] parts = name.split("/", 2);
            this.localPart = parts[0];
            if (parts.length > 1) {
                this.childPart = parts[1];
            }
        }
    }
}

