/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.datetime.joda;

import java.util.Calendar;
import java.util.Date;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.joda.DateTimeFormatAnnotationFormatterFactory;
import org.springframework.format.datetime.joda.DateTimeParser;
import org.springframework.format.datetime.joda.JodaTimeConverters;
import org.springframework.format.datetime.joda.MillisecondInstantPrinter;
import org.springframework.format.datetime.joda.ReadableInstantPrinter;
import org.springframework.format.datetime.joda.ReadablePartialPrinter;

public class JodaTimeFormattingConfigurer {
    private String dateStyle;
    private String timeStyle;
    private String dateTimeStyle;
    private boolean useISOFormat;

    public void setDateStyle(String dateStyle) {
        this.dateStyle = dateStyle;
    }

    public void setTimeStyle(String timeStyle) {
        this.timeStyle = timeStyle;
    }

    public void setDateTimeStyle(String dateTimeStyle) {
        this.dateTimeStyle = dateTimeStyle;
    }

    public void setUseISOFormat(boolean useISOFormat) {
        this.useISOFormat = useISOFormat;
    }

    public void installJodaTimeFormatting(FormatterRegistry formatterRegistry) {
        JodaTimeConverters.registerConverters(formatterRegistry.getConverterRegistry());
        DateTimeFormatter jodaDateFormatter = this.getJodaDateFormatter();
        formatterRegistry.addFormatterForFieldType(LocalDate.class, new ReadablePartialPrinter(jodaDateFormatter), new DateTimeParser(jodaDateFormatter));
        DateTimeFormatter jodaTimeFormatter = this.getJodaTimeFormatter();
        formatterRegistry.addFormatterForFieldType(LocalTime.class, new ReadablePartialPrinter(jodaTimeFormatter), new DateTimeParser(jodaTimeFormatter));
        DateTimeFormatter jodaDateTimeFormatter = this.getJodaDateTimeFormatter();
        DateTimeParser dateTimeParser = new DateTimeParser(jodaDateTimeFormatter);
        formatterRegistry.addFormatterForFieldType(LocalDateTime.class, new ReadablePartialPrinter(jodaDateTimeFormatter), dateTimeParser);
        ReadableInstantPrinter readableInstantPrinter = new ReadableInstantPrinter(jodaDateTimeFormatter);
        formatterRegistry.addFormatterForFieldType(ReadableInstant.class, readableInstantPrinter, dateTimeParser);
        formatterRegistry.addFormatterForFieldType(Calendar.class, readableInstantPrinter, dateTimeParser);
        formatterRegistry.addFormatterForFieldType(Date.class, new MillisecondInstantPrinter(jodaDateTimeFormatter), dateTimeParser);
        formatterRegistry.addFormatterForFieldAnnotation(new DateTimeFormatAnnotationFormatterFactory());
    }

    private DateTimeFormatter getJodaDateFormatter() {
        if (this.useISOFormat) {
            return ISODateTimeFormat.date();
        }
        if (this.dateStyle != null) {
            return DateTimeFormat.forStyle((String)(String.valueOf(this.dateStyle) + "-"));
        }
        return DateTimeFormat.shortDate();
    }

    private DateTimeFormatter getJodaTimeFormatter() {
        if (this.useISOFormat) {
            return ISODateTimeFormat.time();
        }
        if (this.timeStyle != null) {
            return DateTimeFormat.forStyle((String)("-" + this.timeStyle));
        }
        return DateTimeFormat.shortTime();
    }

    private DateTimeFormatter getJodaDateTimeFormatter() {
        if (this.useISOFormat) {
            return ISODateTimeFormat.dateTime();
        }
        if (this.dateTimeStyle != null) {
            return DateTimeFormat.forStyle((String)this.dateTimeStyle);
        }
        return DateTimeFormat.shortDateTime();
    }
}

