/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.datetime.joda;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.format.datetime.joda.DateTimeParser;
import org.springframework.format.datetime.joda.MillisecondInstantPrinter;
import org.springframework.format.datetime.joda.ReadableInstantPrinter;
import org.springframework.format.datetime.joda.ReadablePartialPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateTimeFormatAnnotationFormatterFactory
implements AnnotationFormatterFactory<org.springframework.format.annotation.DateTimeFormat> {
    private final Set<Class<?>> fieldTypes = Collections.unmodifiableSet(this.createFieldTypes());

    @Override
    public Set<Class<?>> getFieldTypes() {
        return this.fieldTypes;
    }

    @Override
    public Printer<?> getPrinter(org.springframework.format.annotation.DateTimeFormat annotation, Class<?> fieldType) {
        DateTimeFormatter formatter = this.configureDateTimeFormatterFrom(annotation);
        if (ReadableInstant.class.isAssignableFrom(fieldType)) {
            return new ReadableInstantPrinter(formatter);
        }
        if (ReadablePartial.class.isAssignableFrom(fieldType)) {
            return new ReadablePartialPrinter(formatter);
        }
        if (Calendar.class.isAssignableFrom(fieldType)) {
            return new ReadableInstantPrinter(formatter);
        }
        return new MillisecondInstantPrinter(formatter);
    }

    @Override
    public Parser<DateTime> getParser(org.springframework.format.annotation.DateTimeFormat annotation, Class<?> fieldType) {
        return new DateTimeParser(this.configureDateTimeFormatterFrom(annotation));
    }

    private Set<Class<?>> createFieldTypes() {
        HashSet fieldTypes = new HashSet(8);
        fieldTypes.add(LocalDate.class);
        fieldTypes.add(LocalTime.class);
        fieldTypes.add(LocalDateTime.class);
        fieldTypes.add(DateTime.class);
        fieldTypes.add(DateMidnight.class);
        fieldTypes.add(Date.class);
        fieldTypes.add(Calendar.class);
        fieldTypes.add(Long.class);
        return fieldTypes;
    }

    private DateTimeFormatter configureDateTimeFormatterFrom(org.springframework.format.annotation.DateTimeFormat annotation) {
        if (!annotation.pattern().isEmpty()) {
            return this.forPattern(annotation.pattern());
        }
        if (annotation.iso() != DateTimeFormat.ISO.NONE) {
            return this.forISO(annotation.iso());
        }
        return this.forStyle(annotation.style());
    }

    private DateTimeFormatter forPattern(String pattern) {
        return DateTimeFormat.forPattern((String)pattern);
    }

    private DateTimeFormatter forISO(DateTimeFormat.ISO iso) {
        if (iso == DateTimeFormat.ISO.DATE) {
            return ISODateTimeFormat.date();
        }
        if (iso == DateTimeFormat.ISO.TIME) {
            return ISODateTimeFormat.time();
        }
        return ISODateTimeFormat.dateTime();
    }

    private DateTimeFormatter forStyle(String style) {
        return DateTimeFormat.forStyle((String)style);
    }
}

