/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.datetime;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.format.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormatter
implements Formatter<Date> {
    private String pattern;
    private int style = 2;
    private TimeZone timeZone;
    private boolean lenient = false;

    public DateFormatter() {
    }

    public DateFormatter(String pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    @Override
    public String print(Date date, Locale locale) {
        return this.getDateFormat(locale).format(date);
    }

    @Override
    public Date parse(String formatted, Locale locale) throws ParseException {
        return this.getDateFormat(locale).parse(formatted);
    }

    protected DateFormat getDateFormat(Locale locale) {
        DateFormat dateFormat = this.pattern != null ? new SimpleDateFormat(this.pattern, locale) : DateFormat.getDateInstance(this.style, locale);
        if (this.timeZone != null) {
            dateFormat.setTimeZone(this.timeZone);
        }
        dateFormat.setLenient(this.lenient);
        return dateFormat;
    }
}

