/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.context.LifecycleProcessor;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLifecycleProcessor
implements LifecycleProcessor,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile long shutdownGroupTimeout = 30000L;
    private volatile boolean running;
    private volatile ConfigurableListableBeanFactory beanFactory;

    public void setShutdownGroupTimeout(long shutdownGroupTimeout) {
        this.shutdownGroupTimeout = shutdownGroupTimeout;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.isTrue((boolean)(beanFactory instanceof ConfigurableListableBeanFactory), (String)"A ConfigurableListableBeanFactory is required.");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void start() {
        Map<String, Lifecycle> lifecycleBeans = this.getLifecycleBeans();
        for (String beanName : new LinkedHashSet(lifecycleBeans.keySet())) {
            this.doStart(lifecycleBeans, beanName);
        }
        this.running = true;
    }

    @Override
    public void stop() {
        Map<String, Lifecycle> lifecycleBeans = this.getLifecycleBeans();
        HashMap<Integer, ShutdownGroup> shutdownGroups = new HashMap<Integer, ShutdownGroup>();
        for (Map.Entry<String, Lifecycle> entry : lifecycleBeans.entrySet()) {
            Lifecycle lifecycle = entry.getValue();
            int shutdownOrder = DefaultLifecycleProcessor.getShutdownOrder(lifecycle);
            ShutdownGroup group = (ShutdownGroup)shutdownGroups.get(shutdownOrder);
            if (group == null) {
                group = new ShutdownGroup(shutdownOrder, this.shutdownGroupTimeout, lifecycleBeans);
                shutdownGroups.put(shutdownOrder, group);
            }
            group.add(entry.getKey(), lifecycle);
        }
        if (shutdownGroups.size() > 0) {
            ArrayList keys = new ArrayList(shutdownGroups.keySet());
            Collections.sort(keys);
            for (Integer key : keys) {
                ((ShutdownGroup)shutdownGroups.get(key)).shutdown();
            }
        }
        this.running = false;
    }

    @Override
    public void onRefresh() {
        Map<String, SmartLifecycle> lifecycleBeans = this.getSmartLifecycleBeans();
        for (String beanName : new LinkedHashSet(lifecycleBeans.keySet())) {
            String[] dependenciesForBean;
            SmartLifecycle bean = lifecycleBeans.get(beanName);
            if (bean == null || !bean.isAutoStartup()) continue;
            String[] stringArray = dependenciesForBean = this.beanFactory.getDependenciesForBean(beanName);
            int n = dependenciesForBean.length;
            int n2 = 0;
            while (n2 < n) {
                String dependency = stringArray[n2];
                this.doStart(lifecycleBeans, dependency);
                ++n2;
            }
            if (!bean.isRunning()) {
                bean.start();
            }
            lifecycleBeans.remove(beanName);
        }
    }

    @Override
    public void onClose() {
        this.stop();
    }

    private void doStart(Map<String, ? extends Lifecycle> lifecycleBeans, String beanName) {
        Lifecycle bean = lifecycleBeans.get(beanName);
        if (bean != null && !this.equals(bean)) {
            String[] dependenciesForBean;
            String[] stringArray = dependenciesForBean = this.beanFactory.getDependenciesForBean(beanName);
            int n = dependenciesForBean.length;
            int n2 = 0;
            while (n2 < n) {
                String dependency = stringArray[n2];
                this.doStart(lifecycleBeans, dependency);
                ++n2;
            }
            if (!bean.isRunning()) {
                bean.start();
            }
            lifecycleBeans.remove(beanName);
        }
    }

    private void doStop(Map<String, Lifecycle> lifecycleBeans, String beanName, final CountDownLatch latch) {
        Lifecycle bean = lifecycleBeans.get(beanName);
        if (bean != null) {
            String[] dependentBeans;
            String[] stringArray = dependentBeans = this.beanFactory.getDependentBeans(beanName);
            int n = dependentBeans.length;
            int n2 = 0;
            while (n2 < n) {
                String dependentBean = stringArray[n2];
                this.doStop(lifecycleBeans, dependentBean, latch);
                ++n2;
            }
            if (bean.isRunning()) {
                if (bean instanceof SmartLifecycle) {
                    ((SmartLifecycle)bean).stop(new Runnable(){

                        public void run() {
                            latch.countDown();
                        }
                    });
                } else {
                    bean.stop();
                }
            }
            lifecycleBeans.remove(beanName);
        }
    }

    private Map<String, Lifecycle> getLifecycleBeans() {
        String[] beanNames = this.beanFactory.getSingletonNames();
        LinkedHashMap<String, Lifecycle> beans = new LinkedHashMap<String, Lifecycle>();
        String[] stringArray = beanNames;
        int n = beanNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            Object bean = this.beanFactory.getSingleton(beanName);
            if (bean instanceof Lifecycle && !this.equals(bean)) {
                beans.put(beanName, (Lifecycle)bean);
            }
            ++n2;
        }
        return beans;
    }

    private Map<String, SmartLifecycle> getSmartLifecycleBeans() {
        String[] beanNames = this.beanFactory.getSingletonNames();
        LinkedHashMap<String, SmartLifecycle> beans = new LinkedHashMap<String, SmartLifecycle>();
        String[] stringArray = beanNames;
        int n = beanNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            Object bean = this.beanFactory.getSingleton(beanName);
            if (bean instanceof SmartLifecycle) {
                beans.put(beanName, (SmartLifecycle)bean);
            }
            ++n2;
        }
        return beans;
    }

    private static int getShutdownOrder(Lifecycle bean) {
        return bean instanceof SmartLifecycle ? ((SmartLifecycle)bean).getShutdownOrder() : Integer.MAX_VALUE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShutdownGroup {
        private final List<ShutdownGroupMember> members = new ArrayList<ShutdownGroupMember>();
        private Map<String, Lifecycle> lifecycleBeans;
        private volatile int smartMemberCount;
        private final int order;
        private final long timeout;

        ShutdownGroup(int order, long timeout, Map<String, Lifecycle> lifecycleBeans) {
            this.lifecycleBeans = DefaultLifecycleProcessor.this.getLifecycleBeans();
            this.order = order;
            this.timeout = timeout;
            this.lifecycleBeans = lifecycleBeans;
        }

        void add(String name, Lifecycle bean) {
            if (bean instanceof SmartLifecycle) {
                ++this.smartMemberCount;
            }
            this.members.add(new ShutdownGroupMember(name, bean));
        }

        void shutdown() {
            if (this.members.size() == 0) {
                return;
            }
            Collections.sort(this.members);
            CountDownLatch latch = new CountDownLatch(this.smartMemberCount);
            for (ShutdownGroupMember member : this.members) {
                if (this.lifecycleBeans.containsKey(member.name)) {
                    DefaultLifecycleProcessor.this.doStop(this.lifecycleBeans, member.name, latch);
                    continue;
                }
                if (!(member.bean instanceof SmartLifecycle)) continue;
                latch.countDown();
            }
            try {
                latch.await(this.timeout, TimeUnit.MILLISECONDS);
                if (latch.getCount() != 0L && DefaultLifecycleProcessor.this.logger.isWarnEnabled()) {
                    DefaultLifecycleProcessor.this.logger.warn((Object)("failed to shutdown beans with order " + this.order + " within timeout of " + this.timeout));
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShutdownGroupMember
    implements Comparable<ShutdownGroupMember> {
        private String name;
        private Lifecycle bean;

        ShutdownGroupMember(String name, Lifecycle bean) {
            this.name = name;
            this.bean = bean;
        }

        @Override
        public int compareTo(ShutdownGroupMember other) {
            int otherOrder;
            int thisOrder = DefaultLifecycleProcessor.getShutdownOrder(this.bean);
            return thisOrder == (otherOrder = DefaultLifecycleProcessor.getShutdownOrder(other.bean)) ? 0 : (thisOrder < otherOrder ? -1 : 1);
        }
    }
}

