/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import org.springframework.util.PropertyPlaceholderHelper;

public abstract class SystemPropertyUtils {
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    public static final String VALUE_SEPARATOR = ":";
    private static final PropertyPlaceholderHelper strictHelper = new PropertyPlaceholderHelper("${", "}", ":", false);
    private static final PropertyPlaceholderHelper nonStrictHelper = new PropertyPlaceholderHelper("${", "}", ":", true);

    public static String resolvePlaceholders(String text) {
        return SystemPropertyUtils.resolvePlaceholders(text, false);
    }

    public static String resolvePlaceholders(String text, boolean ignoreUnresolvablePlaceholders) {
        if (ignoreUnresolvablePlaceholders) {
            return nonStrictHelper.replacePlaceholders(text, new PlaceholderResolverImplementation(text));
        }
        return strictHelper.replacePlaceholders(text, new PlaceholderResolverImplementation(text));
    }

    private static final class PlaceholderResolverImplementation
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final String text;

        private PlaceholderResolverImplementation(String text) {
            this.text = text;
        }

        public String resolvePlaceholder(String placeholderName) {
            String propVal = null;
            try {
                propVal = System.getProperty(placeholderName);
                if (propVal == null) {
                    propVal = System.getenv(placeholderName);
                }
                if (propVal == null) {
                    System.err.println("Could not resolve placeholder '" + placeholderName + "' in [" + this.text + "] as system property: neither system property nor environment variable found");
                }
            }
            catch (Throwable ex) {
                System.err.println("Could not resolve placeholder '" + placeholderName + "' in [" + this.text + "] as system property: " + ex);
            }
            return propVal;
        }
    }
}

