/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ArrayToMapConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.GenericConverter;
import org.springframework.core.convert.support.MapEntryConverter;

final class ObjectToMapConverter
implements GenericConverter {
    private final GenericConversionService conversionService;
    private final ArrayToMapConverter helperConverter;

    public ObjectToMapConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
        this.helperConverter = new ArrayToMapConverter(conversionService);
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        if (sourceType.typeEquals(String.class)) {
            String string = (String)source;
            String[] properties = string.split(" ");
            return this.helperConverter.convert(properties, TypeDescriptor.valueOf(String[].class), targetType);
        }
        Map target = CollectionFactory.createMap(targetType.getType(), 1);
        TypeDescriptor targetKeyType = targetType.getMapKeyTypeDescriptor();
        TypeDescriptor targetValueType = targetType.getMapValueTypeDescriptor();
        boolean keysCompatible = false;
        if (targetKeyType == TypeDescriptor.NULL || sourceType.isAssignableTo(targetKeyType)) {
            keysCompatible = true;
        }
        boolean valuesCompatible = false;
        if (targetValueType == TypeDescriptor.NULL || sourceType.isAssignableTo(targetValueType)) {
            valuesCompatible = true;
        }
        if (keysCompatible && valuesCompatible) {
            target.put(source, source);
        } else {
            MapEntryConverter converter = new MapEntryConverter(sourceType, sourceType, targetKeyType, targetValueType, keysCompatible, valuesCompatible, this.conversionService);
            Object key = converter.convertKey(source);
            Object value = converter.convertValue(source);
            target.put(key, value);
        }
        return target;
    }
}

