/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Iterator;
import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.GenericConverter;
import org.springframework.core.convert.support.MapEntryConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapToMapConverter
implements GenericConverter {
    private final GenericConversionService conversionService;

    public MapToMapConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        Map sourceMap = (Map)source;
        TypeDescriptor targetKeyType = targetType.getMapKeyTypeDescriptor();
        TypeDescriptor targetValueType = targetType.getMapValueTypeDescriptor();
        if (targetKeyType == TypeDescriptor.NULL && targetValueType == TypeDescriptor.NULL) {
            return this.compatibleMapWithoutEntryConversion(sourceMap, targetType);
        }
        TypeDescriptor[] sourceEntryTypes = this.getMapEntryTypes(sourceMap);
        TypeDescriptor sourceKeyType = sourceEntryTypes[0];
        TypeDescriptor sourceValueType = sourceEntryTypes[1];
        if (sourceKeyType == TypeDescriptor.NULL && sourceValueType == TypeDescriptor.NULL) {
            return this.compatibleMapWithoutEntryConversion(sourceMap, targetType);
        }
        boolean keysCompatible = false;
        if (sourceKeyType != TypeDescriptor.NULL && targetKeyType != TypeDescriptor.NULL && sourceKeyType.isAssignableTo(targetKeyType)) {
            keysCompatible = true;
        }
        boolean valuesCompatible = false;
        if (sourceValueType != TypeDescriptor.NULL && targetValueType != TypeDescriptor.NULL && sourceValueType.isAssignableTo(targetValueType)) {
            valuesCompatible = true;
        }
        if (keysCompatible && valuesCompatible) {
            return this.compatibleMapWithoutEntryConversion(sourceMap, targetType);
        }
        Map targetMap = CollectionFactory.createMap(targetType.getType(), sourceMap.size());
        MapEntryConverter converter = new MapEntryConverter(sourceKeyType, sourceValueType, targetKeyType, targetValueType, keysCompatible, valuesCompatible, this.conversionService);
        Iterator iterator = sourceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry sourceMapEntry = entry = iterator.next();
            Object targetKey = converter.convertKey(sourceMapEntry.getKey());
            Object targetValue = converter.convertValue(sourceMapEntry.getValue());
            targetMap.put(targetKey, targetValue);
        }
        return targetMap;
    }

    private TypeDescriptor[] getMapEntryTypes(Map<?, ?> sourceMap) {
        Class<?> keyType = null;
        Class<?> valueType = null;
        Iterator<Map.Entry<?, ?>> iterator = sourceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry;
            Map.Entry<?, ?> mapEntry = entry = iterator.next();
            Object key = mapEntry.getKey();
            if (keyType == null && key != null) {
                keyType = key.getClass();
            }
            Object value = mapEntry.getValue();
            if (valueType == null && value != null) {
                valueType = value.getClass();
            }
            if (mapEntry.getKey() != null && mapEntry.getValue() != null) break;
        }
        return new TypeDescriptor[]{TypeDescriptor.valueOf(keyType), TypeDescriptor.valueOf(valueType)};
    }

    private Map<?, ?> compatibleMapWithoutEntryConversion(Map<?, ?> source, TypeDescriptor targetType) {
        if (targetType.getType().isAssignableFrom(source.getClass())) {
            return source;
        }
        Map target = CollectionFactory.createMap(targetType.getType(), source.size());
        target.putAll(source);
        return target;
    }
}

