/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.GenericConverter;
import org.springframework.core.convert.support.MapEntryConverter;

final class MapToCollectionConverter
implements GenericConverter {
    private final GenericConversionService conversionService;

    public MapToCollectionConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        Map sourceMap = (Map)source;
        TypeDescriptor sourceKeyType = sourceType.getMapKeyTypeDescriptor();
        TypeDescriptor sourceValueType = sourceType.getMapValueTypeDescriptor();
        TypeDescriptor targetElementType = targetType.getElementTypeDescriptor();
        boolean keysCompatible = false;
        if (targetElementType == TypeDescriptor.NULL || sourceKeyType.isAssignableTo(targetElementType)) {
            keysCompatible = true;
        }
        boolean valuesCompatible = false;
        if (targetElementType == TypeDescriptor.NULL || sourceValueType.isAssignableTo(targetElementType)) {
            valuesCompatible = true;
        }
        Collection target = CollectionFactory.createCollection(targetType.getType(), sourceMap.size());
        MapEntryConverter converter = new MapEntryConverter(sourceKeyType, sourceValueType, targetElementType, targetElementType, keysCompatible, valuesCompatible, this.conversionService);
        if (targetElementType.getType().equals(String.class)) {
            Iterator iterator = sourceMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry mapEntry = entry = iterator.next();
                String property = converter.convertKey(mapEntry.getKey()) + "=" + converter.convertValue(mapEntry.getValue());
                target.add(property);
            }
        } else {
            for (Object value : sourceMap.values()) {
                target.add(value);
            }
        }
        return target;
    }
}

