/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.GenericConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConversionUtils {
    ConversionUtils() {
    }

    public static Object invokeConverter(GenericConverter converter, Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return converter.convert(source, sourceType, targetType);
        }
        catch (Exception ex) {
            throw new ConversionFailedException(sourceType, targetType, source, ex);
        }
    }

    public static TypeDescriptor getElementType(Collection<?> collection) {
        for (Object element : collection) {
            if (element == null) continue;
            return TypeDescriptor.valueOf(element.getClass());
        }
        return TypeDescriptor.NULL;
    }

    public static List<?> asList(Object array) {
        return array != null ? new ArrayList(array) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayList
    extends AbstractList<Object>
    implements RandomAccess,
    Serializable {
        private Object array;

        ArrayList(Object array) {
            this.array = array;
        }

        @Override
        public int size() {
            return Array.getLength(this.array);
        }

        @Override
        public Object get(int index) {
            return Array.get(this.array, index);
        }
    }
}

