/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.GenericConverter;

final class CollectionToObjectConverter
implements GenericConverter {
    private static final String DELIMITER = ",";
    private final GenericConversionService conversionService;

    public CollectionToObjectConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        Collection sourceCollection = (Collection)source;
        if (sourceCollection.size() == 0) {
            if (targetType.typeEquals(String.class)) {
                return "";
            }
            return null;
        }
        if (targetType.typeEquals(String.class)) {
            TypeDescriptor sourceElementType = sourceType.getElementTypeDescriptor();
            if (sourceElementType == TypeDescriptor.NULL) {
                sourceElementType = ConversionUtils.getElementType(sourceCollection);
            }
            if (sourceElementType == TypeDescriptor.NULL || sourceElementType.isAssignableTo(targetType)) {
                StringBuilder string = new StringBuilder();
                int i = 0;
                for (Object element : sourceCollection) {
                    if (i > 0) {
                        string.append(DELIMITER);
                    }
                    string.append(element);
                    ++i;
                }
                return string.toString();
            }
            GenericConverter converter = this.conversionService.getConverter(sourceElementType, targetType);
            if (converter == null) {
                throw new ConverterNotFoundException(sourceElementType, targetType);
            }
            StringBuilder string = new StringBuilder();
            int i = 0;
            for (Object sourceElement : sourceCollection) {
                if (i > 0) {
                    string.append(DELIMITER);
                }
                Object targetElement = ConversionUtils.invokeConverter(converter, sourceElement, sourceElementType, targetType);
                string.append(targetElement);
                ++i;
            }
            return string.toString();
        }
        Object firstElement = sourceCollection.iterator().next();
        TypeDescriptor sourceElementType = sourceType.getElementTypeDescriptor();
        if (sourceElementType == TypeDescriptor.NULL && firstElement != null) {
            sourceElementType = TypeDescriptor.valueOf(firstElement.getClass());
        }
        if (sourceElementType == TypeDescriptor.NULL || sourceElementType.isAssignableTo(targetType)) {
            return firstElement;
        }
        GenericConverter converter = this.conversionService.getConverter(sourceElementType, targetType);
        if (converter == null) {
            throw new ConverterNotFoundException(sourceElementType, targetType);
        }
        return ConversionUtils.invokeConverter(converter, firstElement, sourceElementType, targetType);
    }
}

