/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.osgi.web.context;

import com.mtvnet.boxspring.osgi.context.AbstractPathedOsgiBundleXmlApplicationContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.osgi.framework.BundleContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.osgi.context.ConfigurableOsgiBundleApplicationContext;
import org.springframework.osgi.io.OsgiBundleResource;
import org.springframework.osgi.web.context.support.OsgiBundleXmlWebApplicationContext;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.UiApplicationContextUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class PathedOsgiBundleXmlWebApplicationContext
extends AbstractPathedOsgiBundleXmlApplicationContext
implements ConfigurableWebApplicationContext,
ThemeSource {
    public static final String DEFAULT_RESOURCE_ROOT = "/WEB-INF/";
    public static final String[] DEFAULT_FILE_NAMES = new String[]{"applicationContext.xml", "osgi-context.xml"};
    private static final String APPLICATION_CONTEXT_SERVICE_NAMESPACE_PROPERTY = "org.springframework.web.context.namespace";
    private static final String DEFAULT_NAMESPACE_SUFFIX = "-servlet";
    private String[] fileNames;
    private String namespace;
    private Resource[] rootResources;
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private ThemeSource themeSource;

    public PathedOsgiBundleXmlWebApplicationContext() {
        this.setDisplayName("Root PathedOsgiWebApplicationContext");
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Theme getTheme(String themeName) {
        return this.themeSource.getTheme(themeName);
    }

    public void setConfigLocation(String location) {
        this.setConfigLocations(StringUtils.tokenizeToStringArray((String)location, (String)",; \t\n"));
    }

    public void setConfigLocations(String[] locations) {
        if (locations != null) {
            Assert.noNullElements((Object[])locations, (String)"Config locations must not be null");
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (int i = 0; i < locations.length; ++i) {
                Resource[] resourcesToAdd = this.resolveResources(locations[i]);
                resources.addAll(Arrays.asList(resourcesToAdd));
            }
            this.rootResources = resources.toArray(new Resource[0]);
        } else {
            this.rootResources = null;
        }
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            this.setDisplayName("WebApplicationContext for namespace '" + namespace + "'");
        }
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        if (servletConfig != null) {
            String fileNameParam;
            if (this.servletContext == null) {
                this.setServletContext(servletConfig.getServletContext());
            }
            if (this.getNamespace() == null) {
                this.setNamespace(this.servletConfig.getServletName() + DEFAULT_NAMESPACE_SUFFIX);
            }
            this.fileNames = (fileNameParam = servletConfig.getInitParameter("contextConfigFileNames")) != null ? StringUtils.tokenizeToStringArray((String)fileNameParam, (String)",; \t\n") : null;
        }
    }

    public void setServletContext(ServletContext servletContext) {
        String fileNameParam;
        this.servletContext = servletContext;
        if (this.getBundleContext() == null) {
            ApplicationContext parent;
            Object context;
            if (servletContext != null && (context = servletContext.getAttribute(OsgiBundleXmlWebApplicationContext.BUNDLE_CONTEXT_ATTRIBUTE)) != null) {
                Assert.isInstanceOf(BundleContext.class, (Object)context);
                this.logger.debug((Object)("Using the bundle context located in the servlet context at " + OsgiBundleXmlWebApplicationContext.BUNDLE_CONTEXT_ATTRIBUTE));
                this.setBundleContext((BundleContext)context);
            }
            if ((parent = this.getParent()) instanceof ConfigurableOsgiBundleApplicationContext) {
                this.logger.debug((Object)"Using the application context parent's bundle context");
                this.setBundleContext(((ConfigurableOsgiBundleApplicationContext)parent).getBundleContext());
            }
        }
        if ((fileNameParam = servletContext.getInitParameter("contextConfigFileNames")) != null) {
            this.fileNames = StringUtils.tokenizeToStringArray((String)fileNameParam, (String)",; \t\n");
        }
    }

    protected void customizeApplicationContextServiceProperties(Map serviceProperties) {
        super.customizeApplicationContextServiceProperties(serviceProperties);
        String ns = this.getNamespace();
        if (ns != null) {
            serviceProperties.put(APPLICATION_CONTEXT_SERVICE_NAMESPACE_PROPERTY, ns);
        }
    }

    protected String[] getDefaultFileNames() {
        if (this.getNamespace() != null) {
            return new String[]{"" + this.getNamespace() + ".xml"};
        }
        return DEFAULT_FILE_NAMES;
    }

    protected Resource[] getDefaultRootResources() {
        return new Resource[]{new OsgiBundleResource(this.getBundle(), DEFAULT_RESOURCE_ROOT)};
    }

    protected String[] getFileNames() {
        return this.fileNames != null ? this.fileNames : this.getDefaultFileNames();
    }

    protected Resource[] getRootResources() {
        return this.rootResources != null ? this.rootResources : this.getDefaultRootResources();
    }

    protected void onRefresh() {
        super.onRefresh();
        this.themeSource = UiApplicationContextUtils.initThemeSource((ApplicationContext)this);
    }

    protected Resource[] resolveResources(String path) {
        try {
            return this.getResources(SystemPropertyUtils.resolvePlaceholders((String)path));
        }
        catch (IllegalArgumentException e) {
            this.logger.debug((Object)("Unable to resolve resources for path " + path), (Throwable)e);
            return new Resource[0];
        }
        catch (IOException e) {
            this.logger.error((Object)("Unable to resolve resources for path " + path), (Throwable)e);
            return new Resource[0];
        }
    }
}

