/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.util;

import org.springframework.util.PropertyPlaceholderHelper;

public class GentleSystemPropertyUtils {
    public static final String LOG_PLACEHOLDER_ERROR_KEY = "boxspring.log.placeholders";
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    public static final String VALUE_SEPARATOR = ":";
    private static final PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", ":", false);

    public static String resolvePlaceholders(final String text) {
        return helper.replacePlaceholders(text, new PropertyPlaceholderHelper.PlaceholderResolver(){

            public String resolvePlaceholder(String placeholderName) {
                String propVal = null;
                try {
                    propVal = System.getProperty(placeholderName);
                    if (propVal == null) {
                        propVal = System.getenv(placeholderName);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (propVal == null && System.getProperty(GentleSystemPropertyUtils.LOG_PLACEHOLDER_ERROR_KEY) != null) {
                    System.err.println("[PROBABLY IGNORABLE] Could not resolve placeholder '" + placeholderName + "' in [" + text + "] as system property.");
                }
                return propVal;
            }
        });
    }
}

