/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.ns;

import com.mtvnet.boxspring.jmx.ListableBeanFactoryDynamicMBean;
import com.mtvnet.boxspring.jmx.ObjectNameRootPostfixProvider;
import com.mtvnet.boxspring.jmx.PathedDynamicMBeanPostProcessor;
import com.mtvnet.boxspring.ns.AbstractJMXBeanDefinitionParser;
import com.mtvnet.boxspring.ns.NamespaceUtils;
import com.mtvnet.boxspring.path.PathedBeanFactory;
import java.lang.reflect.Field;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ExposeContextBeanDefinitionParser
extends AbstractJMXBeanDefinitionParser {
    private static final String DEFAULT_NAME = "context";
    private static final String EXPORTER_BEAN_NAME = "jmxExporter";
    private static final String NAME = "name";
    private static final String NON_PATHED_PREFIX = "name";
    private static final String ROOT = "spring";
    private static final String ROOT_PATHED_PREFIX = "level0";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        if (!NamespaceUtils.insideGoogleAppEngine) {
            this.createExporter(parserContext);
            if (parserContext.getRegistry() instanceof PathedBeanFactory) {
                this.createPostProcessor(element, parserContext);
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
            builder.getRawBeanDefinition().setBeanClass(ListableBeanFactoryDynamicMBean.class);
            return builder.getBeanDefinition();
        }
        return null;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return this.getId(element, parserContext.getRegistry());
    }

    private void createExporter(ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.createExporterBeanDefinition();
        AbstractBeanDefinition exporterDef = builder.getBeanDefinition();
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)exporterDef, EXPORTER_BEAN_NAME);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
    }

    private void createPostProcessor(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        builder.getRawBeanDefinition().setBeanClass(PathedDynamicMBeanPostProcessor.class);
        builder.addConstructorArgReference(EXPORTER_BEAN_NAME);
        builder.addConstructorArgValue((Object)this.getId(element, parserContext.getRegistry()));
        AbstractBeanDefinition processorDef = builder.getBeanDefinition();
        String beanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)processorDef);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)processorDef, beanName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
    }

    private ApplicationContext extractApplicationContext(BeanPostProcessor beanPostProcessor) {
        ApplicationContext retval = null;
        try {
            Field f = beanPostProcessor.getClass().getDeclaredField("applicationContext");
            if (f != null) {
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                    retval = (ApplicationContext)f.get(beanPostProcessor);
                    f.setAccessible(false);
                } else {
                    retval = (ApplicationContext)f.get(beanPostProcessor);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    private String getId(Element element, BeanDefinitionRegistry registry) {
        String name = this.getRootContextName(element);
        String contextIndicator = "name";
        if (registry instanceof PathedBeanFactory) {
            contextIndicator = ROOT_PATHED_PREFIX;
        }
        String rootPostfix = this.getRootPostfix(registry);
        String id = String.format("%s%s:%s=%s", ROOT, rootPostfix, contextIndicator, name);
        return id;
    }

    private String getRootContextName(Element element) {
        String name = element.getAttribute("name");
        if (!StringUtils.hasText((String)name)) {
            name = DEFAULT_NAME;
        }
        return name;
    }

    private String getRootPostfix(BeanDefinitionRegistry registry) {
        String postfix;
        if (registry instanceof ObjectNameRootPostfixProvider && (postfix = ((ObjectNameRootPostfixProvider)registry).getRootPostfix()) != null) {
            return "." + postfix;
        }
        return "";
    }
}

