/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.layers;

import com.mtvnet.boxspring.layers.CollectionOpUtils;
import com.mtvnet.boxspring.layers.LayeredBeanUtils;
import java.util.HashMap;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.w3c.dom.Element;

public class LayeredBeanDefinitionParserDelegate
extends BeanDefinitionParserDelegate {
    public LayeredBeanDefinitionParserDelegate(XmlReaderContext readerContext) {
        super(readerContext);
    }

    public BeanDefinitionHolder parseBeanDefinitionElement(Element ele, BeanDefinition containingBean) {
        BeanDefinitionHolder holder = super.parseBeanDefinitionElement(ele, containingBean);
        if (holder != null) {
            String beanName = holder.getBeanName();
            BeanDefinition newDefinition = holder.getBeanDefinition();
            BeanDefinitionRegistry registry = this.getReaderContext().getRegistry();
            if (registry.containsBeanDefinition(beanName)) {
                LayeredBeanUtils.applyBeanDefinition(newDefinition, beanName, registry, true);
                return null;
            }
            MutablePropertyValues propertyValues = holder.getBeanDefinition().getPropertyValues();
            HashMap<PropertyValue, PropertyValue> replacements = new HashMap<PropertyValue, PropertyValue>();
            for (PropertyValue prop : propertyValues.getPropertyValues()) {
                if (!CollectionOpUtils.hasOp(prop)) continue;
                replacements.put(prop, CollectionOpUtils.createReplacementProperty(prop));
            }
            for (PropertyValue prop : replacements.keySet()) {
                propertyValues.removePropertyValue(prop);
                PropertyValue replacement = (PropertyValue)replacements.get(prop);
                if (replacement == null) continue;
                propertyValues.addPropertyValue(replacement);
            }
        }
        return holder;
    }
}

