/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.layers;

import com.mtvnet.boxspring.layers.Op;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.util.Assert;

public class CollectionOpUtils {
    private static final String ADD = "+";
    private static final String REMOVE = "-";
    private static final String DOUBLE_ADD = "++";
    private static final String DOUBLE_REMOVE = "--";

    public static boolean hasOp(PropertyValue value) {
        return CollectionOpUtils.getOp(value) != null;
    }

    public static String getRealName(PropertyValue value) {
        Assert.isTrue((boolean)CollectionOpUtils.hasOp(value));
        String name = value.getName();
        if (name.startsWith(DOUBLE_ADD) || name.startsWith(DOUBLE_REMOVE)) {
            return name.substring(2);
        }
        if (name.startsWith(ADD) || name.startsWith(REMOVE)) {
            return name.substring(1);
        }
        if (name.endsWith(DOUBLE_ADD) || name.endsWith(DOUBLE_REMOVE)) {
            return name.substring(0, name.length() - 2);
        }
        return name.substring(0, name.length() - 1);
    }

    public static void processOp(PropertyValue prop, MutablePropertyValues existingProperties) {
        Assert.isTrue((boolean)CollectionOpUtils.hasOp(prop));
        String realName = CollectionOpUtils.getRealName(prop);
        Op op = CollectionOpUtils.getOp(prop);
        if (existingProperties.contains(realName)) {
            PropertyValue existingProperty = existingProperties.getPropertyValue(realName);
            if (existingProperty.getValue() instanceof Collection && prop.getValue() instanceof Collection) {
                Collection existingCollection = (Collection)existingProperty.getValue();
                Collection newCollection = (Collection)prop.getValue();
                switch (op) {
                    case PREPEND: {
                        if (existingCollection instanceof List) {
                            ((List)existingCollection).addAll(0, newCollection);
                            break;
                        }
                        existingCollection.addAll(newCollection);
                        break;
                    }
                    case APPEND: {
                        existingCollection.addAll(newCollection);
                        break;
                    }
                    case REMOVE: {
                        existingCollection.removeAll(newCollection);
                    }
                }
            } else if (existingProperty.getValue() instanceof Map && prop.getValue() instanceof Map) {
                Map existingMap = (Map)existingProperty.getValue();
                Map newMap = (Map)prop.getValue();
                switch (op) {
                    case PREPEND: 
                    case APPEND: {
                        existingMap.putAll(newMap);
                        break;
                    }
                    case REMOVE: {
                        for (Object key : newMap.keySet()) {
                            existingMap.remove(key);
                        }
                        break;
                    }
                }
            }
        } else if (CollectionOpUtils.shouldCreateProperty(prop)) {
            existingProperties.addPropertyValue(new PropertyValue(realName, prop.getValue()));
        }
    }

    private static boolean shouldCreateProperty(PropertyValue prop) {
        return prop.getName().startsWith(ADD) || prop.getName().endsWith(ADD);
    }

    static Op getOp(PropertyValue prop) {
        if (prop.getName().startsWith(ADD) && !prop.getName().startsWith(DOUBLE_ADD) || prop.getName().endsWith(DOUBLE_ADD) || prop.getName().endsWith(ADD)) {
            return Op.APPEND;
        }
        if (prop.getName().startsWith(DOUBLE_ADD)) {
            return Op.PREPEND;
        }
        if (prop.getName().startsWith(REMOVE) || prop.getName().endsWith(REMOVE)) {
            return Op.REMOVE;
        }
        return null;
    }

    public static PropertyValue createReplacementProperty(PropertyValue prop) {
        if (CollectionOpUtils.shouldCreateProperty(prop)) {
            return new PropertyValue(CollectionOpUtils.getRealName(prop), prop.getValue());
        }
        return null;
    }
}

