/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.xml.BeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultBeanDefinitionDocumentReader
implements BeanDefinitionDocumentReader {
    public static final String BEAN_ELEMENT = "bean";
    public static final String ALIAS_ELEMENT = "alias";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ALIAS_ATTRIBUTE = "alias";
    public static final String IMPORT_ELEMENT = "import";
    public static final String RESOURCE_ATTRIBUTE = "resource";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private XmlReaderContext readerContext;

    public void registerBeanDefinitions(Document doc, XmlReaderContext readerContext) {
        this.readerContext = readerContext;
        this.logger.debug((Object)"Loading bean definitions");
        Element root = doc.getDocumentElement();
        BeanDefinitionParserDelegate delegate = this.createHelper(readerContext, root);
        this.preProcessXml(root);
        this.parseBeanDefinitions(root, delegate);
        this.postProcessXml(root);
    }

    protected BeanDefinitionParserDelegate createHelper(XmlReaderContext readerContext, Element root) {
        BeanDefinitionParserDelegate delegate = new BeanDefinitionParserDelegate(readerContext);
        delegate.initDefaults(root);
        return delegate;
    }

    protected final XmlReaderContext getReaderContext() {
        return this.readerContext;
    }

    protected Object extractSource(Element ele) {
        return this.readerContext.extractSource(ele);
    }

    protected void parseBeanDefinitions(Element root, BeanDefinitionParserDelegate delegate) {
        if (delegate.isDefaultNamespace(delegate.getNamespaceURI(root))) {
            NodeList nl = root.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node instanceof Element) {
                    Element ele = (Element)node;
                    String namespaceUri = delegate.getNamespaceURI(ele);
                    if (delegate.isDefaultNamespace(namespaceUri)) {
                        this.parseDefaultElement(ele, delegate);
                    } else {
                        delegate.parseCustomElement(ele);
                    }
                }
                ++i;
            }
        } else {
            delegate.parseCustomElement(root);
        }
    }

    private void parseDefaultElement(Element ele, BeanDefinitionParserDelegate delegate) {
        if (delegate.nodeNameEquals(ele, IMPORT_ELEMENT)) {
            this.importBeanDefinitionResource(ele);
        } else if (delegate.nodeNameEquals(ele, "alias")) {
            this.processAliasRegistration(ele);
        } else if (delegate.nodeNameEquals(ele, BEAN_ELEMENT)) {
            this.processBeanDefinition(ele, delegate);
        }
    }

    protected void importBeanDefinitionResource(Element ele) {
        String location = ele.getAttribute(RESOURCE_ATTRIBUTE);
        if (!StringUtils.hasText((String)location)) {
            this.getReaderContext().error("Resource location must not be empty", ele);
            return;
        }
        location = SystemPropertyUtils.resolvePlaceholders((String)location);
        LinkedHashSet<Resource> actualResources = new LinkedHashSet<Resource>(4);
        boolean absoluteLocation = false;
        try {
            absoluteLocation = ResourceUtils.toURI((String)location).isAbsolute();
        }
        catch (Exception exception) {}
        if (absoluteLocation) {
            try {
                int importCount = this.getReaderContext().getReader().loadBeanDefinitions(location, actualResources);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Imported " + importCount + " bean definitions from URL location [" + location + "]"));
                }
            }
            catch (BeanDefinitionStoreException ex) {
                this.getReaderContext().error("Failed to import bean definitions from URL location [" + location + "]", (Object)ele, (Throwable)((Object)ex));
            }
        } else {
            try {
                String baseLocation = this.getReaderContext().getResource().getURL().toString();
                int importCount = this.getReaderContext().getReader().loadBeanDefinitions(StringUtils.applyRelativePath((String)baseLocation, (String)location), actualResources);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Imported " + importCount + " bean definitions from relative location [" + location + "]"));
                }
            }
            catch (IOException ex) {
                this.getReaderContext().error("Failed to resolve current resource location", (Object)ele, ex);
            }
            catch (BeanDefinitionStoreException ex) {
                this.getReaderContext().error("Failed to import bean definitions from relative location [" + location + "]", (Object)ele, (Throwable)((Object)ex));
            }
        }
        Resource[] actResArray = actualResources.toArray(new Resource[actualResources.size()]);
        this.getReaderContext().fireImportProcessed(location, actResArray, this.extractSource(ele));
    }

    protected void processAliasRegistration(Element ele) {
        String name = ele.getAttribute(NAME_ATTRIBUTE);
        String alias = ele.getAttribute("alias");
        boolean valid = true;
        if (!StringUtils.hasText((String)name)) {
            this.getReaderContext().error("Name must not be empty", ele);
            valid = false;
        }
        if (!StringUtils.hasText((String)alias)) {
            this.getReaderContext().error("Alias must not be empty", ele);
            valid = false;
        }
        if (valid) {
            try {
                this.getReaderContext().getRegistry().registerAlias(name, alias);
            }
            catch (Exception ex) {
                this.getReaderContext().error("Failed to register alias '" + alias + "' for bean with name '" + name + "'", (Object)ele, ex);
            }
            this.getReaderContext().fireAliasRegistered(name, alias, this.extractSource(ele));
        }
    }

    protected void processBeanDefinition(Element ele, BeanDefinitionParserDelegate delegate) {
        BeanDefinitionHolder bdHolder = delegate.parseBeanDefinitionElement(ele);
        if (bdHolder != null) {
            bdHolder = delegate.decorateBeanDefinitionIfRequired(ele, bdHolder);
            try {
                BeanDefinitionReaderUtils.registerBeanDefinition(bdHolder, this.getReaderContext().getRegistry());
            }
            catch (BeanDefinitionStoreException ex) {
                this.getReaderContext().error("Failed to register bean definition with name '" + bdHolder.getBeanName() + "'", (Object)ele, (Throwable)((Object)ex));
            }
            this.getReaderContext().fireComponentRegistered(new BeanComponentDefinition(bdHolder));
        }
    }

    protected void preProcessXml(Element root) {
    }

    protected void postProcessXml(Element root) {
    }
}

