/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.osgi.web.extender.internal;

import java.io.IOException;
import java.net.URL;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class ResourceFindingHttpContext
implements HttpContext {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private Bundle bundle;
    private MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();

    public ResourceFindingHttpContext(Bundle bundle) {
        this.bundle = bundle;
    }

    public String getMimeType(String name) {
        String mimeType = this.mimeTypesMap.getContentType(name);
        if (DEFAULT_CONTENT_TYPE.equals(mimeType) && name.endsWith("/")) {
            mimeType = this.mimeTypesMap.getContentType(name.substring(0, name.length() - 1));
        }
        return mimeType;
    }

    public URL getResource(String name) {
        URL res;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((res = this.bundle.getResource(name)) == null && name.endsWith("/")) {
            res = this.bundle.getResource(name.substring(0, name.length() - 1));
        }
        return res;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }
}

