/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.osgi.context;

import com.mtvnet.boxspring.path.ChildPathedBeanFactoryPostProcessor;
import com.mtvnet.boxspring.path.PathedBeanFactory;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.osgi.context.BundleContextAware;

public class BundleContextAwareChildPostProcessor
extends ChildPathedBeanFactoryPostProcessor {
    private BundleContext bundleContext;
    private BeanPostProcessor beanPostProcessor;

    public BundleContextAwareChildPostProcessor(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.beanPostProcessor = new BundleContextAwareProcessor();
    }

    protected Object postProcessChildBeanFactory(PathedBeanFactory beanFactory, String beanName) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ((ConfigurableBeanFactory)beanFactory).addBeanPostProcessor(this.beanPostProcessor);
        }
        return beanFactory;
    }

    private class BundleContextAwareProcessor
    implements BeanPostProcessor {
        private BundleContextAwareProcessor() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof BundleContextAware) {
                ((BundleContextAware)bean).setBundleContext(BundleContextAwareChildPostProcessor.this.bundleContext);
            }
            return bean;
        }
    }
}

