/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScheduledTasksBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected boolean shouldGenerateId() {
        return true;
    }

    protected String getBeanClassName(Element element) {
        return "org.springframework.scheduling.config.ScheduledTaskRegistrar";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ManagedMap cronTaskMap = new ManagedMap();
        ManagedMap fixedDelayTaskMap = new ManagedMap();
        ManagedMap fixedRateTaskMap = new ManagedMap();
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            if (child instanceof Element && child.getLocalName().equals("scheduled")) {
                Element taskElement = (Element)child;
                String ref = taskElement.getAttribute("ref");
                String method = taskElement.getAttribute("method");
                if (!StringUtils.hasText((String)ref) || !StringUtils.hasText((String)method)) {
                    parserContext.getReaderContext().error("Both 'ref' and 'method' are required", (Object)taskElement);
                } else {
                    RuntimeBeanReference runnableBeanRef = new RuntimeBeanReference(this.createRunnableBean(ref, method, taskElement, parserContext));
                    String cronAttribute = taskElement.getAttribute("cron");
                    if (StringUtils.hasText((String)cronAttribute)) {
                        cronTaskMap.put((Object)runnableBeanRef, (Object)cronAttribute);
                    } else {
                        String fixedDelayAttribute = taskElement.getAttribute("fixed-delay");
                        if (StringUtils.hasText((String)fixedDelayAttribute)) {
                            fixedDelayTaskMap.put((Object)runnableBeanRef, (Object)fixedDelayAttribute);
                        } else {
                            String fixedRateAttribute = taskElement.getAttribute("fixed-rate");
                            if (!StringUtils.hasText((String)fixedRateAttribute)) {
                                parserContext.getReaderContext().error("One of 'cron', 'fixed-delay', or 'fixed-rate' is required", (Object)taskElement);
                            } else {
                                fixedRateTaskMap.put((Object)runnableBeanRef, (Object)fixedRateAttribute);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        String schedulerRef = element.getAttribute("scheduler");
        if (StringUtils.hasText((String)schedulerRef)) {
            builder.addPropertyReference("taskScheduler", schedulerRef);
        }
        builder.addPropertyValue("cronTasks", (Object)cronTaskMap);
        builder.addPropertyValue("fixedDelayTasks", (Object)fixedDelayTaskMap);
        builder.addPropertyValue("fixedRateTasks", (Object)fixedRateTaskMap);
    }

    private String createRunnableBean(String ref, String method, Element taskElement, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.scheduling.support.MethodInvokingRunnable");
        builder.addPropertyReference("targetObject", ref);
        builder.addPropertyValue("targetMethod", (Object)method);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)taskElement));
        String generatedName = parserContext.getReaderContext().generateBeanName((BeanDefinition)builder.getRawBeanDefinition());
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)builder.getBeanDefinition(), generatedName));
        return generatedName;
    }
}

