/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.JdkVersion;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ExecutorBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected String getBeanClassName(Element element) {
        if (this.shouldUseBackport(element)) {
            return "org.springframework.scheduling.backportconcurrent.ThreadPoolTaskExecutor";
        }
        return "org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String queueCapacity;
        String keepAliveSeconds = element.getAttribute("keep-alive");
        if (StringUtils.hasText((String)keepAliveSeconds)) {
            builder.addPropertyValue("keepAliveSeconds", (Object)keepAliveSeconds);
        }
        if (StringUtils.hasText((String)(queueCapacity = element.getAttribute("queue-capacity")))) {
            builder.addPropertyValue("queueCapacity", (Object)queueCapacity);
        }
        this.configureRejectionPolicy(element, builder);
        String size = element.getAttribute("size");
        if (!StringUtils.hasText((String)size)) {
            return;
        }
        Integer[] range = null;
        try {
            int separatorIndex = size.indexOf(45);
            if (separatorIndex != -1) {
                range = new Integer[]{Integer.valueOf(size.substring(0, separatorIndex)), Integer.valueOf(size.substring(separatorIndex + 1, size.length()))};
                if (range[0] > range[1]) {
                    parserContext.getReaderContext().error("Lower bound of size range must not exceed the upper bound.", (Object)element);
                }
                if (!StringUtils.hasText((String)queueCapacity)) {
                    if (range[0] == 0) {
                        builder.addPropertyValue("allowCoreThreadTimeOut", (Object)true);
                        range[0] = range[1];
                    } else {
                        parserContext.getReaderContext().error("A non-zero lower bound for the size range requires a queue-capacity value.", (Object)element);
                    }
                }
            } else {
                Integer value = Integer.valueOf(size);
                range = new Integer[]{value, value};
            }
        }
        catch (NumberFormatException ex) {
            parserContext.getReaderContext().error("Invalid size value [" + size + "]: only " + "single maximum integer (e.g. \"5\") and minimum-maximum combo (e.g. \"3-5\") supported.", (Object)element, (Throwable)ex);
        }
        if (range != null) {
            builder.addPropertyValue("corePoolSize", (Object)range[0]);
            builder.addPropertyValue("maxPoolSize", (Object)range[1]);
        }
    }

    private void configureRejectionPolicy(Element element, BeanDefinitionBuilder builder) {
        String rejectionPolicy = element.getAttribute("rejection-policy");
        if (!StringUtils.hasText((String)rejectionPolicy)) {
            return;
        }
        Object handler = null;
        boolean createBackportHandler = this.shouldUseBackport(element);
        if (rejectionPolicy.equals("ABORT")) {
            handler = createBackportHandler ? new ThreadPoolExecutor.AbortPolicy() : new ThreadPoolExecutor.AbortPolicy();
        }
        if (rejectionPolicy.equals("CALLER_RUNS")) {
            handler = createBackportHandler ? new ThreadPoolExecutor.CallerRunsPolicy() : new ThreadPoolExecutor.CallerRunsPolicy();
        }
        if (rejectionPolicy.equals("DISCARD")) {
            if (createBackportHandler) {
                handler = new ThreadPoolExecutor.DiscardPolicy();
            }
            handler = new ThreadPoolExecutor.DiscardPolicy();
        }
        if (rejectionPolicy.equals("DISCARD_OLDEST")) {
            if (createBackportHandler) {
                handler = new ThreadPoolExecutor.DiscardOldestPolicy();
            }
            handler = new ThreadPoolExecutor.DiscardOldestPolicy();
        }
        builder.addPropertyValue("rejectedExecutionHandler", handler);
    }

    private boolean shouldUseBackport(Element element) {
        String size = element.getAttribute("size");
        return StringUtils.hasText((String)size) && size.startsWith("0") && JdkVersion.getMajorJavaVersion() < 3;
    }
}

