/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.path;

import com.mtvnet.boxspring.path.ChildPathedBeanFactoryPostProcessor;
import com.mtvnet.boxspring.path.PathedBeanFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class ApplicationContextAwareChildPostProcessor
extends ChildPathedBeanFactoryPostProcessor {
    private ApplicationContext applicationContext;
    private BeanPostProcessor beanPostProcessor;

    public ApplicationContextAwareChildPostProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.beanPostProcessor = new ApplicationContextAwareProcessor();
    }

    protected Object postProcessChildBeanFactory(PathedBeanFactory beanFactory, String beanName) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ((ConfigurableBeanFactory)beanFactory).addBeanPostProcessor(this.beanPostProcessor);
        }
        return beanFactory;
    }

    private class ApplicationContextAwareProcessor
    implements BeanPostProcessor {
        private ApplicationContextAwareProcessor() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)bean).setResourceLoader((ResourceLoader)ApplicationContextAwareChildPostProcessor.this.applicationContext);
            }
            if (bean instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)bean).setApplicationEventPublisher((ApplicationEventPublisher)ApplicationContextAwareChildPostProcessor.this.applicationContext);
            }
            if (bean instanceof MessageSourceAware) {
                ((MessageSourceAware)bean).setMessageSource((MessageSource)ApplicationContextAwareChildPostProcessor.this.applicationContext);
            }
            if (bean instanceof ApplicationContextAware) {
                ((ApplicationContextAware)bean).setApplicationContext(ApplicationContextAwareChildPostProcessor.this.applicationContext);
            }
            return bean;
        }
    }
}

