/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.jmx;

import com.mtvnet.boxspring.jmx.ListableBeanFactoryDynamicMBean;
import com.mtvnet.boxspring.path.PathedBeanFactory;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;

class JMXHelper {
    private static final Log LOGGER = LogFactory.getLog(JMXHelper.class);

    private JMXHelper() {
    }

    public static ObjectName generateBeanName(Object managedBean, String beanKey, BeanFactory beanFactory) throws MalformedObjectNameException {
        if (beanFactory instanceof PathedBeanFactory) {
            PathedBeanFactory pathedFactory = (PathedBeanFactory)beanFactory;
            Map factoryMBeans = pathedFactory.getBeansOfType(ListableBeanFactoryDynamicMBean.class);
            if (factoryMBeans.isEmpty()) {
                LOGGER.info((Object)"Unable to find a ListableBeanFactoryDynamicMBean in the factory");
                return null;
            }
            String name = (String)factoryMBeans.keySet().toArray()[0];
            return new ObjectName(name + "," + StringUtils.substringAfterLast((String)beanKey, (String)":"));
        }
        LOGGER.info((Object)"Not able to resolve the path, falling through to KeyNamingStrategy");
        return null;
    }
}

