/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.jmx;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.support.JmxUtils;
import org.springframework.util.MethodInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppServerMBeanServerFactoryBean
implements FactoryBean<MBeanServer>,
InitializingBean {
    private static final String JBOSS_LOCATOR_CLASS = "org.jboss.mx.util.MBeanServerLocator";
    private static final String JBOSS_LOCATOR_METHOD = "locateJBoss";
    private static final Log LOGGER = LogFactory.getLog(AppServerMBeanServerFactoryBean.class);
    private boolean jboss = true;
    private Map<String, MBeanServerLocator> locators;

    public void afterPropertiesSet() {
        this.locators = new LinkedHashMap<String, MBeanServerLocator>();
        if (this.jboss) {
            this.addLocator("jboss", JBOSS_LOCATOR_CLASS, JBOSS_LOCATOR_METHOD);
        }
    }

    public MBeanServer getObject() throws Exception {
        for (String locatorName : this.locators.keySet()) {
            LOGGER.info((Object)("Attempting to load MBean server for app server: " + locatorName));
            MBeanServer server = this.locators.get(locatorName).locateServer();
            if (server == null) continue;
            return server;
        }
        return JmxUtils.locateMBeanServer();
    }

    public Class<MBeanServer> getObjectType() {
        return MBeanServer.class;
    }

    public boolean isJboss() {
        return this.jboss;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setJboss(boolean jboss) {
        this.jboss = jboss;
    }

    private void addLocator(String name, String locatorClass, String locatorMethod) {
        try {
            this.locators.put(name, new MBeanServerLocator(locatorClass, locatorMethod));
        }
        catch (ClassNotFoundException e) {
            LOGGER.info((Object)("Adding locator: " + name + " failed. Might want to exclude it."));
        }
        catch (NoSuchMethodException e) {
            LOGGER.info((Object)("Adding locator: " + name + " failed. Might want to exclude it."));
        }
    }

    private class MBeanServerLocator
    extends MethodInvoker {
        public MBeanServerLocator(String clazz, String method) throws ClassNotFoundException, NoSuchMethodException {
            Class<?> locatorClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(clazz);
            this.setTargetClass(locatorClass);
            this.setTargetMethod(method);
            this.prepare();
        }

        public MBeanServer locateServer() {
            try {
                return (MBeanServer)this.invoke();
            }
            catch (Exception e) {
                LOGGER.info((Object)"Exception while trying to locate server", (Throwable)e);
                return null;
            }
        }
    }
}

