/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.global;

import com.mtvnet.boxspring.layers.LayeredBeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class GlobalBeanUtils {
    public static final String GLOBAL_BEAN_NAME = "GLOBAL";

    public static void applyGlobalBean(BeanDefinitionRegistry registry) {
        if (GlobalBeanUtils.containsGlobalBean(registry)) {
            BeanDefinition globalBean = GlobalBeanUtils.getGlobalBean(registry);
            GlobalBeanUtils.applyGlobalBean(registry, globalBean);
        }
    }

    public static void applyGlobalBean(BeanDefinitionRegistry registry, BeanDefinition globalBean) {
        for (String beanName : registry.getBeanDefinitionNames()) {
            if (beanName.equals(GLOBAL_BEAN_NAME)) continue;
            LayeredBeanUtils.applyBeanDefinition(globalBean, beanName, registry, false, "from GLOBAL");
        }
    }

    public static boolean containsGlobalBean(BeanDefinitionRegistry registry) {
        return registry.containsBeanDefinition(GLOBAL_BEAN_NAME);
    }

    public static BeanDefinition getGlobalBean(BeanDefinitionRegistry registry) {
        return registry.getBeanDefinition(GLOBAL_BEAN_NAME);
    }
}

